/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request for the resource record sets that are associated with a specified hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListResourceRecordSetsRequest extends Route53Request implements
        ToCopyableBuilder<ListResourceRecordSetsRequest.Builder, ListResourceRecordSetsRequest> {
    private final String hostedZoneId;

    private final String startRecordName;

    private final String startRecordType;

    private final String startRecordIdentifier;

    private final String maxItems;

    private ListResourceRecordSetsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.startRecordName = builder.startRecordName;
        this.startRecordType = builder.startRecordType;
        this.startRecordIdentifier = builder.startRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The ID of the hosted zone that contains the resource record sets that you want to list.
     * </p>
     * 
     * @return The ID of the hosted zone that contains the resource record sets that you want to list.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The first name in the lexicographic ordering of resource record sets that you want to list.
     * </p>
     * 
     * @return The first name in the lexicographic ordering of resource record sets that you want to list.
     */
    public String startRecordName() {
        return startRecordName;
    }

    /**
     * <p>
     * The type of resource record set to begin the record listing from.
     * </p>
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     * <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code>
     * | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code> |
     * <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for alias resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CloudFront distribution</b>: A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ELB load balancer</b>: A | AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon S3 bucket</b>: A
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias
     * references.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
     * <code>InvalidInput</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startRecordTypeAsString}.
     * </p>
     * 
     * @return The type of resource record set to begin the record listing from.</p>
     *         <p>
     *         Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     *         <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
     *         <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code>
     *         | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     *         <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for alias resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CloudFront distribution</b>: A or AAAA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ELB load balancer</b>: A | AAAA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon S3 bucket</b>: A
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the
     *         alias references.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
     *         <code>InvalidInput</code> error.
     * @see RRType
     */
    public RRType startRecordType() {
        return RRType.fromValue(startRecordType);
    }

    /**
     * <p>
     * The type of resource record set to begin the record listing from.
     * </p>
     * <p>
     * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     * <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> | <code>SOA</code>
     * | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code> |
     * <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     * </p>
     * <p>
     * Values for alias resource record sets:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CloudFront distribution</b>: A or AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ELB load balancer</b>: A | AAAA
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon S3 bucket</b>: A
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias
     * references.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
     * <code>InvalidInput</code> error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startRecordType}
     * will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #startRecordTypeAsString}.
     * </p>
     * 
     * @return The type of resource record set to begin the record listing from.</p>
     *         <p>
     *         Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
     *         <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
     *         <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code>
     *         | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
     *         <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
     *         </p>
     *         <p>
     *         Values for alias resource record sets:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CloudFront distribution</b>: A or AAAA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ELB load balancer</b>: A | AAAA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon S3 bucket</b>: A
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the
     *         alias references.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
     *         <code>InvalidInput</code> error.
     * @see RRType
     */
    public String startRecordTypeAsString() {
        return startRecordType;
    }

    /**
     * <p>
     * <i>Weighted resource record sets only:</i> If results were truncated for a given DNS name and type, specify the
     * value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set that
     * has the current DNS name and type.
     * </p>
     * 
     * @return <i>Weighted resource record sets only:</i> If results were truncated for a given DNS name and type,
     *         specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next
     *         resource record set that has the current DNS name and type.
     */
    public String startRecordIdentifier() {
        return startRecordIdentifier;
    }

    /**
     * <p>
     * (Optional) The maximum number of resource records sets to include in the response body for this request. If the
     * response includes more than <code>maxitems</code> resource record sets, the value of the <code>IsTruncated</code>
     * element in the response is <code>true</code>, and the values of the <code>NextRecordName</code> and
     * <code>NextRecordType</code> elements in the response identify the first resource record set in the next group of
     * <code>maxitems</code> resource record sets.
     * </p>
     * 
     * @return (Optional) The maximum number of resource records sets to include in the response body for this request.
     *         If the response includes more than <code>maxitems</code> resource record sets, the value of the
     *         <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the
     *         <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
     *         resource record set in the next group of <code>maxitems</code> resource record sets.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(startRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(startRecordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsRequest)) {
            return false;
        }
        ListResourceRecordSetsRequest other = (ListResourceRecordSetsRequest) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(startRecordName(), other.startRecordName())
                && Objects.equals(startRecordTypeAsString(), other.startRecordTypeAsString())
                && Objects.equals(startRecordIdentifier(), other.startRecordIdentifier())
                && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ListResourceRecordSetsRequest").add("HostedZoneId", hostedZoneId())
                .add("StartRecordName", startRecordName()).add("StartRecordType", startRecordTypeAsString())
                .add("StartRecordIdentifier", startRecordIdentifier()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.of(clazz.cast(hostedZoneId()));
        case "StartRecordName":
            return Optional.of(clazz.cast(startRecordName()));
        case "StartRecordType":
            return Optional.of(clazz.cast(startRecordTypeAsString()));
        case "StartRecordIdentifier":
            return Optional.of(clazz.cast(startRecordIdentifier()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, ListResourceRecordSetsRequest> {
        /**
         * <p>
         * The ID of the hosted zone that contains the resource record sets that you want to list.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that contains the resource record sets that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The first name in the lexicographic ordering of resource record sets that you want to list.
         * </p>
         * 
         * @param startRecordName
         *        The first name in the lexicographic ordering of resource record sets that you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startRecordName(String startRecordName);

        /**
         * <p>
         * The type of resource record set to begin the record listing from.
         * </p>
         * <p>
         * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         * <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
         * <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code> |
         * <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
         * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for alias resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CloudFront distribution</b>: A or AAAA
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ELB load balancer</b>: A | AAAA
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon S3 bucket</b>: A
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias
         * references.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
         * <code>InvalidInput</code> error.
         * </p>
         * 
         * @param startRecordType
         *        The type of resource record set to begin the record listing from.</p>
         *        <p>
         *        Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         *        <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
         *        <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for weighted, latency, geo, and failover resource record sets: <code>A</code> |
         *        <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         *        <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for alias resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CloudFront distribution</b>: A or AAAA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ELB load balancer</b>: A | AAAA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon S3 bucket</b>: A
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the
         *        alias references.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
         *        <code>InvalidInput</code> error.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder startRecordType(String startRecordType);

        /**
         * <p>
         * The type of resource record set to begin the record listing from.
         * </p>
         * <p>
         * Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         * <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
         * <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for weighted, latency, geo, and failover resource record sets: <code>A</code> | <code>AAAA</code> |
         * <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>PTR</code> |
         * <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         * </p>
         * <p>
         * Values for alias resource record sets:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CloudFront distribution</b>: A or AAAA
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ELB load balancer</b>: A | AAAA
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon S3 bucket</b>: A
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the alias
         * references.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
         * <code>InvalidInput</code> error.
         * </p>
         * 
         * @param startRecordType
         *        The type of resource record set to begin the record listing from.</p>
         *        <p>
         *        Valid values for basic resource record sets: <code>A</code> | <code>AAAA</code> | <code>CAA</code> |
         *        <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> | <code>NS</code> | <code>PTR</code> |
         *        <code>SOA</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for weighted, latency, geo, and failover resource record sets: <code>A</code> |
         *        <code>AAAA</code> | <code>CAA</code> | <code>CNAME</code> | <code>MX</code> | <code>NAPTR</code> |
         *        <code>PTR</code> | <code>SPF</code> | <code>SRV</code> | <code>TXT</code>
         *        </p>
         *        <p>
         *        Values for alias resource record sets:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CloudFront distribution</b>: A or AAAA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Elastic Beanstalk environment that has a regionalized subdomain</b>: A
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ELB load balancer</b>: A | AAAA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon S3 bucket</b>: A
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Another resource record set in this hosted zone:</b> The type of the resource record set that the
         *        alias references.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Constraint: Specifying <code>type</code> without specifying <code>name</code> returns an
         *        <code>InvalidInput</code> error.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder startRecordType(RRType startRecordType);

        /**
         * <p>
         * <i>Weighted resource record sets only:</i> If results were truncated for a given DNS name and type, specify
         * the value of <code>NextRecordIdentifier</code> from the previous response to get the next resource record set
         * that has the current DNS name and type.
         * </p>
         * 
         * @param startRecordIdentifier
         *        <i>Weighted resource record sets only:</i> If results were truncated for a given DNS name and type,
         *        specify the value of <code>NextRecordIdentifier</code> from the previous response to get the next
         *        resource record set that has the current DNS name and type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startRecordIdentifier(String startRecordIdentifier);

        /**
         * <p>
         * (Optional) The maximum number of resource records sets to include in the response body for this request. If
         * the response includes more than <code>maxitems</code> resource record sets, the value of the
         * <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the
         * <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the first
         * resource record set in the next group of <code>maxitems</code> resource record sets.
         * </p>
         * 
         * @param maxItems
         *        (Optional) The maximum number of resource records sets to include in the response body for this
         *        request. If the response includes more than <code>maxitems</code> resource record sets, the value of
         *        the <code>IsTruncated</code> element in the response is <code>true</code>, and the values of the
         *        <code>NextRecordName</code> and <code>NextRecordType</code> elements in the response identify the
         *        first resource record set in the next group of <code>maxitems</code> resource record sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String hostedZoneId;

        private String startRecordName;

        private String startRecordType;

        private String startRecordIdentifier;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsRequest model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            startRecordName(model.startRecordName);
            startRecordType(model.startRecordType);
            startRecordIdentifier(model.startRecordIdentifier);
            maxItems(model.maxItems);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getStartRecordName() {
            return startRecordName;
        }

        @Override
        public final Builder startRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
            return this;
        }

        public final void setStartRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
        }

        public final String getStartRecordType() {
            return startRecordType;
        }

        @Override
        public final Builder startRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
            return this;
        }

        @Override
        public final Builder startRecordType(RRType startRecordType) {
            this.startRecordType(startRecordType.toString());
            return this;
        }

        public final void setStartRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
        }

        public final String getStartRecordIdentifier() {
            return startRecordIdentifier;
        }

        @Override
        public final Builder startRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
            return this;
        }

        public final void setStartRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListResourceRecordSetsRequest build() {
            return new ListResourceRecordSetsRequest(this);
        }
    }
}
