/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the health checks or hosted zones for which you want to list tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourceResponse extends Route53Response implements
        ToCopyableBuilder<ListTagsForResourceResponse.Builder, ListTagsForResourceResponse> {
    private final ResourceTagSet resourceTagSet;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSet = builder.resourceTagSet;
    }

    /**
     * <p>
     * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     * </p>
     * 
     * @return A <code>ResourceTagSet</code> containing tags associated with the specified resource.
     */
    public ResourceTagSet resourceTagSet() {
        return resourceTagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTagSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse) obj;
        return Objects.equals(resourceTagSet(), other.resourceTagSet());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourceResponse").add("ResourceTagSet", resourceTagSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTagSet":
            return Optional.of(clazz.cast(resourceTagSet()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListTagsForResourceResponse> {
        /**
         * <p>
         * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * </p>
         * 
         * @param resourceTagSet
         *        A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSet(ResourceTagSet resourceTagSet);

        /**
         * <p>
         * A <code>ResourceTagSet</code> containing tags associated with the specified resource.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceTagSet.Builder} avoiding the need to
         * create one manually via {@link ResourceTagSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceTagSet.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceTagSet(ResourceTagSet)}.
         * 
         * @param resourceTagSet
         *        a consumer that will call methods on {@link ResourceTagSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagSet(ResourceTagSet)
         */
        default Builder resourceTagSet(Consumer<ResourceTagSet.Builder> resourceTagSet) {
            return resourceTagSet(ResourceTagSet.builder().apply(resourceTagSet).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private ResourceTagSet resourceTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            resourceTagSet(model.resourceTagSet);
        }

        public final ResourceTagSet.Builder getResourceTagSet() {
            return resourceTagSet != null ? resourceTagSet.toBuilder() : null;
        }

        @Override
        public final Builder resourceTagSet(ResourceTagSet resourceTagSet) {
            this.resourceTagSet = resourceTagSet;
            return this;
        }

        public final void setResourceTagSet(ResourceTagSet.BuilderImpl resourceTagSet) {
            this.resourceTagSet = resourceTagSet != null ? resourceTagSet.build() : null;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }
    }
}
