/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the health checks or hosted zones for which you want to list tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourcesRequest extends Route53Request implements
        ToCopyableBuilder<ListTagsForResourcesRequest.Builder, ListTagsForResourcesRequest> {
    private final String resourceType;

    private final List<String> resourceIds;

    private ListTagsForResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
    }

    /**
     * <p>
     * The type of the resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resources.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public TagResourceType resourceType() {
        return TagResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resources.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link TagResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resources.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * A complex type that contains the ResourceId element for each resource for which you want to get a list of tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains the ResourceId element for each resource for which you want to get a list of
     *         tags.
     */
    public List<String> resourceIds() {
        return resourceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesRequest)) {
            return false;
        }
        ListTagsForResourcesRequest other = (ListTagsForResourcesRequest) obj;
        return Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceIds(), other.resourceIds());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourcesRequest").add("ResourceType", resourceTypeAsString())
                .add("ResourceIds", resourceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.of(clazz.cast(resourceTypeAsString()));
        case "ResourceIds":
            return Optional.of(clazz.cast(resourceIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, ListTagsForResourcesRequest> {
        /**
         * <p>
         * The type of the resources.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resources.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resources.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resources.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(TagResourceType resourceType);

        /**
         * <p>
         * A complex type that contains the ResourceId element for each resource for which you want to get a list of
         * tags.
         * </p>
         * 
         * @param resourceIds
         *        A complex type that contains the ResourceId element for each resource for which you want to get a list
         *        of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(Collection<String> resourceIds);

        /**
         * <p>
         * A complex type that contains the ResourceId element for each resource for which you want to get a list of
         * tags.
         * </p>
         * 
         * @param resourceIds
         *        A complex type that contains the ResourceId element for each resource for which you want to get a list
         *        of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(String... resourceIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String resourceType;

        private List<String> resourceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesRequest model) {
            super(model);
            resourceType(model.resourceType);
            resourceIds(model.resourceIds);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getResourceIds() {
            return resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = TagResourceIdListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String... resourceIds) {
            resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = TagResourceIdListCopier.copy(resourceIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourcesRequest build() {
            return new ListTagsForResourcesRequest(this);
        }
    }
}
