/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing tags for the specified resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsForResourcesResponse extends Route53Response implements
        ToCopyableBuilder<ListTagsForResourcesResponse.Builder, ListTagsForResourcesResponse> {
    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagSets = builder.resourceTagSets;
    }

    /**
     * <p>
     * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
     */
    public List<ResourceTagSet> resourceTagSets() {
        return resourceTagSets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceTagSets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse) obj;
        return Objects.equals(resourceTagSets(), other.resourceTagSets());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsForResourcesResponse").add("ResourceTagSets", resourceTagSets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceTagSets":
            return Optional.of(clazz.cast(resourceTagSets()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * 
         * @param resourceTagSets
         *        A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagSets(ResourceTagSet... resourceTagSets);

        /**
         * <p>
         * A list of <code>ResourceTagSet</code>s containing tags associated with the specified resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceTagSet>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceTagSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceTagSet>.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceTagSets(List<ResourceTagSet>)}.
         * 
         * @param resourceTagSets
         *        a consumer that will call methods on {@link List<ResourceTagSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagSets(List<ResourceTagSet>)
         */
        Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<ResourceTagSet> resourceTagSets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            super(model);
            resourceTagSets(model.resourceTagSets);
        }

        public final Collection<ResourceTagSet.Builder> getResourceTagSets() {
            return resourceTagSets != null ? resourceTagSets.stream().map(ResourceTagSet::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet... resourceTagSets) {
            resourceTagSets(Arrays.asList(resourceTagSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(Consumer<ResourceTagSet.Builder>... resourceTagSets) {
            resourceTagSets(Stream.of(resourceTagSets).map(c -> ResourceTagSet.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet.BuilderImpl> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copyFromBuilder(resourceTagSets);
        }

        @Override
        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }
    }
}
