/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Private hosted zones only) A complex type that contains information about an Amazon VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VPC implements ToCopyableBuilder<VPC.Builder, VPC> {
    private final String vpcRegion;

    private final String vpcId;

    private VPC(BuilderImpl builder) {
        this.vpcRegion = builder.vpcRegion;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * (Private hosted zones only) The region in which you created an Amazon VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return (Private hosted zones only) The region in which you created an Amazon VPC.
     * @see VPCRegion
     */
    public VPCRegion vpcRegion() {
        return VPCRegion.fromValue(vpcRegion);
    }

    /**
     * <p>
     * (Private hosted zones only) The region in which you created an Amazon VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcRegion} will
     * return {@link VPCRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcRegionAsString}.
     * </p>
     * 
     * @return (Private hosted zones only) The region in which you created an Amazon VPC.
     * @see VPCRegion
     */
    public String vpcRegionAsString() {
        return vpcRegion;
    }

    /**
     * Returns the value of the VPCId property for this object.
     * 
     * @return The value of the VPCId property for this object.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPC)) {
            return false;
        }
        VPC other = (VPC) obj;
        return Objects.equals(vpcRegionAsString(), other.vpcRegionAsString()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("VPC").add("VPCRegion", vpcRegionAsString()).add("VPCId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VPCRegion":
            return Optional.of(clazz.cast(vpcRegionAsString()));
        case "VPCId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VPC> {
        /**
         * <p>
         * (Private hosted zones only) The region in which you created an Amazon VPC.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region in which you created an Amazon VPC.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(String vpcRegion);

        /**
         * <p>
         * (Private hosted zones only) The region in which you created an Amazon VPC.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region in which you created an Amazon VPC.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(VPCRegion vpcRegion);

        /**
         * Sets the value of the VPCId property for this object.
         *
         * @param vpcId
         *        The new value for the VPCId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String vpcRegion;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VPC model) {
            vpcRegion(model.vpcRegion);
            vpcId(model.vpcId);
        }

        public final String getVPCRegion() {
            return vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion.toString());
            return this;
        }

        public final void setVPCRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        public final String getVPCId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVPCId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VPC build() {
            return new VPC(this);
        }
    }
}
