/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * HealthCheckConfig StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class HealthCheckConfigUnmarshaller implements Unmarshaller<HealthCheckConfig, StaxUnmarshallerContext> {

    public HealthCheckConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        HealthCheckConfig.Builder healthCheckConfig = HealthCheckConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> childHealthChecks = null;
        java.util.List<String> regions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                healthCheckConfig.childHealthChecks(childHealthChecks);
                healthCheckConfig.regions(regions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IPAddress", targetDepth)) {
                    healthCheckConfig.ipAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Port", targetDepth)) {
                    healthCheckConfig.port(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Type", targetDepth)) {
                    healthCheckConfig.type(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResourcePath", targetDepth)) {
                    healthCheckConfig.resourcePath(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FullyQualifiedDomainName", targetDepth)) {
                    healthCheckConfig.fullyQualifiedDomainName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("SearchString", targetDepth)) {
                    healthCheckConfig.searchString(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RequestInterval", targetDepth)) {
                    healthCheckConfig.requestInterval(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("FailureThreshold", targetDepth)) {
                    healthCheckConfig.failureThreshold(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MeasureLatency", targetDepth)) {
                    healthCheckConfig.measureLatency(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Inverted", targetDepth)) {
                    healthCheckConfig.inverted(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HealthThreshold", targetDepth)) {
                    healthCheckConfig.healthThreshold(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ChildHealthChecks", targetDepth)) {
                    childHealthChecks = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("ChildHealthChecks/ChildHealthCheck", targetDepth)) {
                    childHealthChecks.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EnableSNI", targetDepth)) {
                    healthCheckConfig.enableSNI(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Regions", targetDepth)) {
                    regions = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("Regions/Region", targetDepth)) {
                    regions.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AlarmIdentifier", targetDepth)) {
                    healthCheckConfig.alarmIdentifier(AlarmIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InsufficientDataHealthStatus", targetDepth)) {
                    healthCheckConfig.insufficientDataHealthStatus(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    healthCheckConfig.childHealthChecks(childHealthChecks);
                    healthCheckConfig.regions(regions);
                    break;
                }
            }
        }
        return healthCheckConfig.build();
    }

    private static final HealthCheckConfigUnmarshaller INSTANCE = new HealthCheckConfigUnmarshaller();

    public static HealthCheckConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}
