/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DeleteTagsForDomainRequest includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTagsForDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<DeleteTagsForDomainRequest.Builder, DeleteTagsForDomainRequest> {
    private final String domainName;

    private final List<String> tagsToDelete;

    private DeleteTagsForDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.tagsToDelete = builder.tagsToDelete;
    }

    /**
     * <p>
     * The domain for which you want to delete one or more tags.
     * </p>
     * 
     * @return The domain for which you want to delete one or more tags.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A list of tag keys to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tag keys to delete.
     */
    public List<String> tagsToDelete() {
        return tagsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(tagsToDelete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsForDomainRequest)) {
            return false;
        }
        DeleteTagsForDomainRequest other = (DeleteTagsForDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(tagsToDelete(), other.tagsToDelete());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteTagsForDomainRequest").add("DomainName", domainName()).add("TagsToDelete", tagsToDelete())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "TagsToDelete":
            return Optional.of(clazz.cast(tagsToDelete()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, DeleteTagsForDomainRequest> {
        /**
         * <p>
         * The domain for which you want to delete one or more tags.
         * </p>
         * 
         * @param domainName
         *        The domain for which you want to delete one or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of tag keys to delete.
         * </p>
         * 
         * @param tagsToDelete
         *        A list of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToDelete(Collection<String> tagsToDelete);

        /**
         * <p>
         * A list of tag keys to delete.
         * </p>
         * 
         * @param tagsToDelete
         *        A list of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsToDelete(String... tagsToDelete);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private List<String> tagsToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsForDomainRequest model) {
            super(model);
            domainName(model.domainName);
            tagsToDelete(model.tagsToDelete);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getTagsToDelete() {
            return tagsToDelete;
        }

        @Override
        public final Builder tagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToDelete(String... tagsToDelete) {
            tagsToDelete(Arrays.asList(tagsToDelete));
            return this;
        }

        public final void setTagsToDelete(Collection<String> tagsToDelete) {
            this.tagsToDelete = TagKeyListCopier.copy(tagsToDelete);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteTagsForDomainRequest build() {
            return new DeleteTagsForDomainRequest(this);
        }
    }
}
