/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.DomainTransferabilityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainTransferability implements StructuredPojo,
        ToCopyableBuilder<DomainTransferability.Builder, DomainTransferability> {
    private final String transferable;

    private DomainTransferability(BuilderImpl builder) {
        this.transferable = builder.transferable;
    }

    /**
     * Returns the value of the Transferable property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferable} will
     * return {@link Transferable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferableAsString}.
     * </p>
     * 
     * @return The value of the Transferable property for this object.
     * @see Transferable
     */
    public Transferable transferable() {
        return Transferable.fromValue(transferable);
    }

    /**
     * Returns the value of the Transferable property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transferable} will
     * return {@link Transferable#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #transferableAsString}.
     * </p>
     * 
     * @return The value of the Transferable property for this object.
     * @see Transferable
     */
    public String transferableAsString() {
        return transferable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transferableAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainTransferability)) {
            return false;
        }
        DomainTransferability other = (DomainTransferability) obj;
        return Objects.equals(transferableAsString(), other.transferableAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DomainTransferability").add("Transferable", transferableAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transferable":
            return Optional.of(clazz.cast(transferableAsString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainTransferabilityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainTransferability> {
        /**
         * Sets the value of the Transferable property for this object.
         *
         * @param transferable
         *        The new value for the Transferable property for this object.
         * @see Transferable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Transferable
         */
        Builder transferable(String transferable);

        /**
         * Sets the value of the Transferable property for this object.
         *
         * @param transferable
         *        The new value for the Transferable property for this object.
         * @see Transferable
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Transferable
         */
        Builder transferable(Transferable transferable);
    }

    static final class BuilderImpl implements Builder {
        private String transferable;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainTransferability model) {
            transferable(model.transferable);
        }

        public final String getTransferable() {
            return transferable;
        }

        @Override
        public final Builder transferable(String transferable) {
            this.transferable = transferable;
            return this;
        }

        @Override
        public final Builder transferable(Transferable transferable) {
            this.transferable(transferable.toString());
            return this;
        }

        public final void setTransferable(String transferable) {
            this.transferable = transferable;
        }

        @Override
        public DomainTransferability build() {
            return new DomainTransferability(this);
        }
    }
}
