/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <a>GetOperationDetail</a> request includes the following element.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationDetailRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<GetOperationDetailRequest.Builder, GetOperationDetailRequest> {
    private final String operationId;

    private GetOperationDetailRequest(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The identifier for the operation for which you want to get the status. Amazon Route 53 returned the identifier in
     * the response to the original request.
     * </p>
     * 
     * @return The identifier for the operation for which you want to get the status. Amazon Route 53 returned the
     *         identifier in the response to the original request.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailRequest)) {
            return false;
        }
        GetOperationDetailRequest other = (GetOperationDetailRequest) obj;
        return Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetOperationDetailRequest").add("OperationId", operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, GetOperationDetailRequest> {
        /**
         * <p>
         * The identifier for the operation for which you want to get the status. Amazon Route 53 returned the
         * identifier in the response to the original request.
         * </p>
         * 
         * @param operationId
         *        The identifier for the operation for which you want to get the status. Amazon Route 53 returned the
         *        identifier in the response to the original request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailRequest model) {
            super(model);
            operationId(model.operationId);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetOperationDetailRequest build() {
            return new GetOperationDetailRequest(this);
        }
    }
}
