/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RenewDomainResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<RenewDomainResponse.Builder, RenewDomainResponse> {
    private final String operationId;

    private RenewDomainResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * The identifier for tracking the progress of the request. To use this ID to query the operation status, use
     * <a>GetOperationDetail</a>.
     * </p>
     * 
     * @return The identifier for tracking the progress of the request. To use this ID to query the operation status,
     *         use <a>GetOperationDetail</a>.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenewDomainResponse)) {
            return false;
        }
        RenewDomainResponse other = (RenewDomainResponse) obj;
        return Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        return ToString.builder("RenewDomainResponse").add("OperationId", operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsResponse.Builder, CopyableBuilder<Builder, RenewDomainResponse> {
        /**
         * <p>
         * The identifier for tracking the progress of the request. To use this ID to query the operation status, use
         * <a>GetOperationDetail</a>.
         * </p>
         * 
         * @param operationId
         *        The identifier for tracking the progress of the request. To use this ID to query the operation status,
         *        use <a>GetOperationDetail</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RenewDomainResponse model) {
            super(model);
            operationId(model.operationId);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public RenewDomainResponse build() {
            return new RenewDomainResponse(this);
        }
    }
}
