/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The TransferDomain request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TransferDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<TransferDomainRequest.Builder, TransferDomainRequest> {
    private final String domainName;

    private final String idnLangCode;

    private final Integer durationInYears;

    private final List<Nameserver> nameservers;

    private final String authCode;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean privacyProtectAdminContact;

    private final Boolean privacyProtectRegistrantContact;

    private final Boolean privacyProtectTechContact;

    private TransferDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.nameservers = builder.nameservers;
        this.authCode = builder.authCode;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
    }

    /**
     * <p>
     * The name of the domain that you want to transfer to Amazon Route 53.
     * </p>
     * <p>
     * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen (-).
     * Internationalized Domain Names are not supported.
     * </p>
     * 
     * @return The name of the domain that you want to transfer to Amazon Route 53.</p>
     *         <p>
     *         Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
     *         hyphen (-). Internationalized Domain Names are not supported.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public String idnLangCode() {
        return idnLangCode;
    }

    /**
     * <p>
     * The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
     * The maximum period depends on the top-level domain.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of years that you want to register the domain for. Domains are registered for a minimum of one
     *         year. The maximum period depends on the top-level domain.</p>
     *         <p>
     *         Default: 1
     */
    public Integer durationInYears() {
        return durationInYears;
    }

    /**
     * <p>
     * Contains details for the host and glue IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Contains details for the host and glue IP addresses.
     */
    public List<Nameserver> nameservers() {
        return nameservers;
    }

    /**
     * <p>
     * The authorization code for the domain. You get this value from the current registrar.
     * </p>
     * 
     * @return The authorization code for the domain. You get this value from the current registrar.
     */
    public String authCode() {
        return authCode;
    }

    /**
     * <p>
     * Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect
     * after the account is charged.
     * </p>
     * <p>
     * Default: true
     * </p>
     * 
     * @return Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes
     *         effect after the account is charged.</p>
     *         <p>
     *         Default: true
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectAdminContact() {
        return privacyProtectAdminContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectRegistrantContact() {
        return privacyProtectRegistrantContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public Boolean privacyProtectTechContact() {
        return privacyProtectTechContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(idnLangCode());
        hashCode = 31 * hashCode + Objects.hashCode(durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(nameservers());
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(techContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectAdminContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectRegistrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectTechContact());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferDomainRequest)) {
            return false;
        }
        TransferDomainRequest other = (TransferDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(idnLangCode(), other.idnLangCode())
                && Objects.equals(durationInYears(), other.durationInYears())
                && Objects.equals(nameservers(), other.nameservers()) && Objects.equals(authCode(), other.authCode())
                && Objects.equals(autoRenew(), other.autoRenew()) && Objects.equals(adminContact(), other.adminContact())
                && Objects.equals(registrantContact(), other.registrantContact())
                && Objects.equals(techContact(), other.techContact())
                && Objects.equals(privacyProtectAdminContact(), other.privacyProtectAdminContact())
                && Objects.equals(privacyProtectRegistrantContact(), other.privacyProtectRegistrantContact())
                && Objects.equals(privacyProtectTechContact(), other.privacyProtectTechContact());
    }

    @Override
    public String toString() {
        return ToString.builder("TransferDomainRequest").add("DomainName", domainName()).add("IdnLangCode", idnLangCode())
                .add("DurationInYears", durationInYears()).add("Nameservers", nameservers()).add("AuthCode", authCode())
                .add("AutoRenew", autoRenew()).add("AdminContact", adminContact()).add("RegistrantContact", registrantContact())
                .add("TechContact", techContact()).add("PrivacyProtectAdminContact", privacyProtectAdminContact())
                .add("PrivacyProtectRegistrantContact", privacyProtectRegistrantContact())
                .add("PrivacyProtectTechContact", privacyProtectTechContact()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "IdnLangCode":
            return Optional.of(clazz.cast(idnLangCode()));
        case "DurationInYears":
            return Optional.of(clazz.cast(durationInYears()));
        case "Nameservers":
            return Optional.of(clazz.cast(nameservers()));
        case "AuthCode":
            return Optional.of(clazz.cast(authCode()));
        case "AutoRenew":
            return Optional.of(clazz.cast(autoRenew()));
        case "AdminContact":
            return Optional.of(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.of(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.of(clazz.cast(techContact()));
        case "PrivacyProtectAdminContact":
            return Optional.of(clazz.cast(privacyProtectAdminContact()));
        case "PrivacyProtectRegistrantContact":
            return Optional.of(clazz.cast(privacyProtectRegistrantContact()));
        case "PrivacyProtectTechContact":
            return Optional.of(clazz.cast(privacyProtectTechContact()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, TransferDomainRequest> {
        /**
         * <p>
         * The name of the domain that you want to transfer to Amazon Route 53.
         * </p>
         * <p>
         * Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and hyphen
         * (-). Internationalized Domain Names are not supported.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to transfer to Amazon Route 53.</p>
         *        <p>
         *        Constraints: The domain name can contain only the letters a through z, the numbers 0 through 9, and
         *        hyphen (-). Internationalized Domain Names are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param idnLangCode
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idnLangCode(String idnLangCode);

        /**
         * <p>
         * The number of years that you want to register the domain for. Domains are registered for a minimum of one
         * year. The maximum period depends on the top-level domain.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param durationInYears
         *        The number of years that you want to register the domain for. Domains are registered for a minimum of
         *        one year. The maximum period depends on the top-level domain.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInYears(Integer durationInYears);

        /**
         * <p>
         * Contains details for the host and glue IP addresses.
         * </p>
         * 
         * @param nameservers
         *        Contains details for the host and glue IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<Nameserver> nameservers);

        /**
         * <p>
         * Contains details for the host and glue IP addresses.
         * </p>
         * 
         * @param nameservers
         *        Contains details for the host and glue IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Nameserver... nameservers);

        /**
         * <p>
         * Contains details for the host and glue IP addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Nameserver>.Builder} avoiding the need to
         * create one manually via {@link List<Nameserver>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Nameserver>.Builder#build()} is called immediately and its
         * result is passed to {@link #nameservers(List<Nameserver>)}.
         * 
         * @param nameservers
         *        a consumer that will call methods on {@link List<Nameserver>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nameservers(List<Nameserver>)
         */
        Builder nameservers(Consumer<Nameserver.Builder>... nameservers);

        /**
         * <p>
         * The authorization code for the domain. You get this value from the current registrar.
         * </p>
         * 
         * @param authCode
         *        The authorization code for the domain. You get this value from the current registrar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);

        /**
         * <p>
         * Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes
         * effect after the account is charged.
         * </p>
         * <p>
         * Default: true
         * </p>
         * 
         * @param autoRenew
         *        Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only
         *        takes effect after the account is charged.</p>
         *        <p>
         *        Default: true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param adminContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #adminContact(ContactDetail)}.
         * 
         * @param adminContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminContact(ContactDetail)
         */
        default Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return adminContact(ContactDetail.builder().apply(adminContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param registrantContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #registrantContact(ContactDetail)}.
         * 
         * @param registrantContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrantContact(ContactDetail)
         */
        default Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return registrantContact(ContactDetail.builder().apply(registrantContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param techContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * This is a convenience that creates an instance of the {@link ContactDetail.Builder} avoiding the need to
         * create one manually via {@link ContactDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #techContact(ContactDetail)}.
         * 
         * @param techContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #techContact(ContactDetail)
         */
        default Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return techContact(ContactDetail.builder().apply(techContact).build());
        }

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectAdminContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectRegistrantContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectTechContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectTechContact(Boolean privacyProtectTechContact);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String idnLangCode;

        private Integer durationInYears;

        private List<Nameserver> nameservers;

        private String authCode;

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean privacyProtectAdminContact;

        private Boolean privacyProtectRegistrantContact;

        private Boolean privacyProtectTechContact;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferDomainRequest model) {
            super(model);
            domainName(model.domainName);
            idnLangCode(model.idnLangCode);
            durationInYears(model.durationInYears);
            nameservers(model.nameservers);
            authCode(model.authCode);
            autoRenew(model.autoRenew);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
            privacyProtectAdminContact(model.privacyProtectAdminContact);
            privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            privacyProtectTechContact(model.privacyProtectTechContact);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getIdnLangCode() {
            return idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        public final Integer getDurationInYears() {
            return durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        public final Collection<Nameserver.Builder> getNameservers() {
            return nameservers != null ? nameservers.stream().map(Nameserver::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver... nameservers) {
            nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Consumer<Nameserver.Builder>... nameservers) {
            nameservers(Stream.of(nameservers).map(c -> Nameserver.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        public final String getAuthCode() {
            return authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TransferDomainRequest build() {
            return new TransferDomainRequest(this);
        }
    }
}
