/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContactPrivacy request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainContactPrivacyRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<UpdateDomainContactPrivacyRequest.Builder, UpdateDomainContactPrivacyRequest> {
    private final String domainName;

    private final Boolean adminPrivacy;

    private final Boolean registrantPrivacy;

    private final Boolean techPrivacy;

    private UpdateDomainContactPrivacyRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
    }

    /**
     * <p>
     * The name of the domain that you want to update the privacy setting for.
     * </p>
     * 
     * @return The name of the domain that you want to update the privacy setting for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean adminPrivacy() {
        return adminPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean registrantPrivacy() {
        return registrantPrivacy;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
     * information that you enter.
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of the
     *         contact information that you enter.
     */
    public Boolean techPrivacy() {
        return techPrivacy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(techPrivacy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactPrivacyRequest)) {
            return false;
        }
        UpdateDomainContactPrivacyRequest other = (UpdateDomainContactPrivacyRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(adminPrivacy(), other.adminPrivacy())
                && Objects.equals(registrantPrivacy(), other.registrantPrivacy())
                && Objects.equals(techPrivacy(), other.techPrivacy());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDomainContactPrivacyRequest").add("DomainName", domainName())
                .add("AdminPrivacy", adminPrivacy()).add("RegistrantPrivacy", registrantPrivacy())
                .add("TechPrivacy", techPrivacy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.of(clazz.cast(domainName()));
        case "AdminPrivacy":
            return Optional.of(clazz.cast(adminPrivacy()));
        case "RegistrantPrivacy":
            return Optional.of(clazz.cast(registrantPrivacy()));
        case "TechPrivacy":
            return Optional.of(clazz.cast(techPrivacy()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, UpdateDomainContactPrivacyRequest> {
        /**
         * <p>
         * The name of the domain that you want to update the privacy setting for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update the privacy setting for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param adminPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPrivacy(Boolean adminPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param registrantPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantPrivacy(Boolean registrantPrivacy);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries will return contact information for our registrar partner, Gandi, instead of the contact
         * information that you enter.
         * </p>
         * 
         * @param techPrivacy
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries will return contact information for our registrar partner, Gandi, instead of
         *        the contact information that you enter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techPrivacy(Boolean techPrivacy);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private Boolean adminPrivacy;

        private Boolean registrantPrivacy;

        private Boolean techPrivacy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactPrivacyRequest model) {
            super(model);
            domainName(model.domainName);
            adminPrivacy(model.adminPrivacy);
            registrantPrivacy(model.registrantPrivacy);
            techPrivacy(model.techPrivacy);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAdminPrivacy() {
            return adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainContactPrivacyRequest build() {
            return new UpdateDomainContactPrivacyRequest(this);
        }
    }
}
