/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ViewBilling request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ViewBillingRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ViewBillingRequest.Builder, ViewBillingRequest> {
    private final Instant start;

    private final Instant end;

    private final String marker;

    private final Integer maxItems;

    private ViewBillingRequest(BuilderImpl builder) {
        super(builder);
        this.start = builder.start;
        this.end = builder.end;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The beginning date and time for the time period for which you want a list of billing records. Specify the date in
     * Unix time format.
     * </p>
     * 
     * @return The beginning date and time for the time period for which you want a list of billing records. Specify the
     *         date in Unix time format.
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The end date and time for the time period for which you want a list of billing records. Specify the date in Unix
     * time format.
     * </p>
     * 
     * @return The end date and time for the time period for which you want a list of billing records. Specify the date
     *         in Unix time format.
     */
    public Instant end() {
        return end;
    }

    /**
     * <p>
     * For an initial request for a list of billing records, omit this element. If the number of billing records that
     * are associated with the current AWS account during the specified period is greater than the value that you
     * specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get
     * the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the
     * value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * <p>
     * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
     * response.
     * </p>
     * 
     * @return For an initial request for a list of billing records, omit this element. If the number of billing records
     *         that are associated with the current AWS account during the specified period is greater than the value
     *         that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional
     *         billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit
     *         another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code>
     *         element. </p>
     *         <p>
     *         Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
     *         previous response.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The number of billing records to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The number of billing records to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingRequest)) {
            return false;
        }
        ViewBillingRequest other = (ViewBillingRequest) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    @Override
    public String toString() {
        return ToString.builder("ViewBillingRequest").add("Start", start()).add("End", end()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.of(clazz.cast(start()));
        case "End":
            return Optional.of(clazz.cast(end()));
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53DomainsRequest.Builder, CopyableBuilder<Builder, ViewBillingRequest> {
        /**
         * <p>
         * The beginning date and time for the time period for which you want a list of billing records. Specify the
         * date in Unix time format.
         * </p>
         * 
         * @param start
         *        The beginning date and time for the time period for which you want a list of billing records. Specify
         *        the date in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end date and time for the time period for which you want a list of billing records. Specify the date in
         * Unix time format.
         * </p>
         * 
         * @param end
         *        The end date and time for the time period for which you want a list of billing records. Specify the
         *        date in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * For an initial request for a list of billing records, omit this element. If the number of billing records
         * that are associated with the current AWS account during the specified period is greater than the value that
         * you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing
         * records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request
         * that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
         * </p>
         * <p>
         * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
         * response.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of billing records, omit this element. If the number of billing
         *        records that are associated with the current AWS account during the specified period is greater than
         *        the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return
         *        additional billing records. Get the value of <code>NextPageMarker</code> from the previous response,
         *        and submit another request that includes the value of <code>NextPageMarker</code> in the
         *        <code>Marker</code> element. </p>
         *        <p>
         *        Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
         *        previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The number of billing records to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        The number of billing records to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingRequest model) {
            super(model);
            start(model.start);
            end(model.end);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ViewBillingRequest build() {
            return new ViewBillingRequest(this);
        }
    }
}
