/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link BillingRecord} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class BillingRecordMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();

    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").isBinary(false).build();

    private static final MarshallingInfo<String> INVOICEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvoiceId").isBinary(false).build();

    private static final MarshallingInfo<Instant> BILLDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BillDate").isBinary(false).build();

    private static final MarshallingInfo<Double> PRICE_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Price").isBinary(false).build();

    private static final BillingRecordMarshaller INSTANCE = new BillingRecordMarshaller();

    private BillingRecordMarshaller() {
    }

    public static BillingRecordMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(BillingRecord billingRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(billingRecord, "billingRecord");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(billingRecord.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(billingRecord.operationAsString(), OPERATION_BINDING);
            protocolMarshaller.marshall(billingRecord.invoiceId(), INVOICEID_BINDING);
            protocolMarshaller.marshall(billingRecord.billDate(), BILLDATE_BINDING);
            protocolMarshaller.marshall(billingRecord.price(), PRICE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
