/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ContactDetail} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ContactDetailMarshaller {
    private static final MarshallingInfo<String> FIRSTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FirstName").isBinary(false).build();

    private static final MarshallingInfo<String> LASTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastName").isBinary(false).build();

    private static final MarshallingInfo<String> CONTACTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContactType").isBinary(false).build();

    private static final MarshallingInfo<String> ORGANIZATIONNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationName").isBinary(false).build();

    private static final MarshallingInfo<String> ADDRESSLINE1_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine1").isBinary(false).build();

    private static final MarshallingInfo<String> ADDRESSLINE2_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AddressLine2").isBinary(false).build();

    private static final MarshallingInfo<String> CITY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("City").isBinary(false).build();

    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();

    private static final MarshallingInfo<String> COUNTRYCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CountryCode").isBinary(false).build();

    private static final MarshallingInfo<String> ZIPCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ZipCode").isBinary(false).build();

    private static final MarshallingInfo<String> PHONENUMBER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumber").isBinary(false).build();

    private static final MarshallingInfo<String> EMAIL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Email").isBinary(false).build();

    private static final MarshallingInfo<String> FAX_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Fax").isBinary(false).build();

    private static final MarshallingInfo<List> EXTRAPARAMS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExtraParams").isBinary(false).build();

    private static final ContactDetailMarshaller INSTANCE = new ContactDetailMarshaller();

    private ContactDetailMarshaller() {
    }

    public static ContactDetailMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ContactDetail contactDetail, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(contactDetail, "contactDetail");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(contactDetail.firstName(), FIRSTNAME_BINDING);
            protocolMarshaller.marshall(contactDetail.lastName(), LASTNAME_BINDING);
            protocolMarshaller.marshall(contactDetail.contactTypeAsString(), CONTACTTYPE_BINDING);
            protocolMarshaller.marshall(contactDetail.organizationName(), ORGANIZATIONNAME_BINDING);
            protocolMarshaller.marshall(contactDetail.addressLine1(), ADDRESSLINE1_BINDING);
            protocolMarshaller.marshall(contactDetail.addressLine2(), ADDRESSLINE2_BINDING);
            protocolMarshaller.marshall(contactDetail.city(), CITY_BINDING);
            protocolMarshaller.marshall(contactDetail.state(), STATE_BINDING);
            protocolMarshaller.marshall(contactDetail.countryCodeAsString(), COUNTRYCODE_BINDING);
            protocolMarshaller.marshall(contactDetail.zipCode(), ZIPCODE_BINDING);
            protocolMarshaller.marshall(contactDetail.phoneNumber(), PHONENUMBER_BINDING);
            protocolMarshaller.marshall(contactDetail.email(), EMAIL_BINDING);
            protocolMarshaller.marshall(contactDetail.fax(), FAX_BINDING);
            protocolMarshaller.marshall(contactDetail.extraParams(), EXTRAPARAMS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
