/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RegisterDomainRequest} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RegisterDomainRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();

    private static final MarshallingInfo<String> IDNLANGCODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdnLangCode").isBinary(false).build();

    private static final MarshallingInfo<Integer> DURATIONINYEARS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationInYears").isBinary(false).build();

    private static final MarshallingInfo<Boolean> AUTORENEW_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoRenew").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ADMINCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdminContact")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REGISTRANTCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("RegistrantContact").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> TECHCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TechContact")
            .isBinary(false).build();

    private static final MarshallingInfo<Boolean> PRIVACYPROTECTADMINCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PrivacyProtectAdminContact").isBinary(false).build();

    private static final MarshallingInfo<Boolean> PRIVACYPROTECTREGISTRANTCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PrivacyProtectRegistrantContact").isBinary(false).build();

    private static final MarshallingInfo<Boolean> PRIVACYPROTECTTECHCONTACT_BINDING = MarshallingInfo
            .builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("PrivacyProtectTechContact").isBinary(false).build();

    private static final RegisterDomainRequestModelMarshaller INSTANCE = new RegisterDomainRequestModelMarshaller();

    private RegisterDomainRequestModelMarshaller() {
    }

    public static RegisterDomainRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RegisterDomainRequest registerDomainRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(registerDomainRequest, "registerDomainRequest");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(registerDomainRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.idnLangCode(), IDNLANGCODE_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.durationInYears(), DURATIONINYEARS_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.autoRenew(), AUTORENEW_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.adminContact(), ADMINCONTACT_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.registrantContact(), REGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.techContact(), TECHCONTACT_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.privacyProtectAdminContact(), PRIVACYPROTECTADMINCONTACT_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.privacyProtectRegistrantContact(),
                    PRIVACYPROTECTREGISTRANTCONTACT_BINDING);
            protocolMarshaller.marshall(registerDomainRequest.privacyProtectTechContact(), PRIVACYPROTECTTECHCONTACT_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
