/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.services.route53.model.LinkedService;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HostedZone
implements ToCopyableBuilder<Builder, HostedZone> {
    private final String id;
    private final String name;
    private final String callerReference;
    private final HostedZoneConfig config;
    private final Long resourceRecordSetCount;
    private final LinkedService linkedService;

    private HostedZone(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.config = builder.config;
        this.resourceRecordSetCount = builder.resourceRecordSetCount;
        this.linkedService = builder.linkedService;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HostedZoneConfig config() {
        return this.config;
    }

    public Long resourceRecordSetCount() {
        return this.resourceRecordSetCount;
    }

    public LinkedService linkedService() {
        return this.linkedService;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.config());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecordSetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkedService());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZone)) {
            return false;
        }
        HostedZone other = (HostedZone)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.config(), other.config()) && Objects.equals(this.resourceRecordSetCount(), other.resourceRecordSetCount()) && Objects.equals(this.linkedService(), other.linkedService());
    }

    public String toString() {
        return ToString.builder((String)"HostedZone").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("CallerReference", (Object)this.callerReference()).add("Config", (Object)this.config()).add("ResourceRecordSetCount", (Object)this.resourceRecordSetCount()).add("LinkedService", (Object)this.linkedService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "CallerReference": {
                return Optional.of(clazz.cast(this.callerReference()));
            }
            case "Config": {
                return Optional.of(clazz.cast(this.config()));
            }
            case "ResourceRecordSetCount": {
                return Optional.of(clazz.cast(this.resourceRecordSetCount()));
            }
            case "LinkedService": {
                return Optional.of(clazz.cast(this.linkedService()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String callerReference;
        private HostedZoneConfig config;
        private Long resourceRecordSetCount;
        private LinkedService linkedService;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZone model) {
            this.id(model.id);
            this.name(model.name);
            this.callerReference(model.callerReference);
            this.config(model.config);
            this.resourceRecordSetCount(model.resourceRecordSetCount);
            this.linkedService(model.linkedService);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getConfig() {
            return this.config != null ? this.config.toBuilder() : null;
        }

        @Override
        public final Builder config(HostedZoneConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HostedZoneConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final Long getResourceRecordSetCount() {
            return this.resourceRecordSetCount;
        }

        @Override
        public final Builder resourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public final void setResourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
        }

        public final LinkedService.Builder getLinkedService() {
            return this.linkedService != null ? this.linkedService.toBuilder() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        public HostedZone build() {
            return new HostedZone(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HostedZone> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder callerReference(String var1);

        public Builder config(HostedZoneConfig var1);

        default public Builder config(Consumer<HostedZoneConfig.Builder> config) {
            return this.config((HostedZoneConfig)((HostedZoneConfig.Builder)HostedZoneConfig.builder().apply(config)).build());
        }

        public Builder resourceRecordSetCount(Long var1);

        public Builder linkedService(LinkedService var1);

        default public Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return this.linkedService((LinkedService)((LinkedService.Builder)LinkedService.builder().apply(linkedService)).build());
        }
    }
}

