/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGeoLocationsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListGeoLocationsRequest> {
    private final String startContinentCode;
    private final String startCountryCode;
    private final String startSubdivisionCode;
    private final String maxItems;

    private ListGeoLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.startContinentCode = builder.startContinentCode;
        this.startCountryCode = builder.startCountryCode;
        this.startSubdivisionCode = builder.startSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    public String startContinentCode() {
        return this.startContinentCode;
    }

    public String startCountryCode() {
        return this.startCountryCode;
    }

    public String startSubdivisionCode() {
        return this.startSubdivisionCode;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsRequest)) {
            return false;
        }
        ListGeoLocationsRequest other = (ListGeoLocationsRequest)((Object)obj);
        return Objects.equals(this.startContinentCode(), other.startContinentCode()) && Objects.equals(this.startCountryCode(), other.startCountryCode()) && Objects.equals(this.startSubdivisionCode(), other.startSubdivisionCode()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListGeoLocationsRequest").add("StartContinentCode", (Object)this.startContinentCode()).add("StartCountryCode", (Object)this.startCountryCode()).add("StartSubdivisionCode", (Object)this.startSubdivisionCode()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartContinentCode": {
                return Optional.of(clazz.cast(this.startContinentCode()));
            }
            case "StartCountryCode": {
                return Optional.of(clazz.cast(this.startCountryCode()));
            }
            case "StartSubdivisionCode": {
                return Optional.of(clazz.cast(this.startSubdivisionCode()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String startContinentCode;
        private String startCountryCode;
        private String startSubdivisionCode;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsRequest model) {
            super(model);
            this.startContinentCode(model.startContinentCode);
            this.startCountryCode(model.startCountryCode);
            this.startSubdivisionCode(model.startSubdivisionCode);
            this.maxItems(model.maxItems);
        }

        public final String getStartContinentCode() {
            return this.startContinentCode;
        }

        @Override
        public final Builder startContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
            return this;
        }

        public final void setStartContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
        }

        public final String getStartCountryCode() {
            return this.startCountryCode;
        }

        @Override
        public final Builder startCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
            return this;
        }

        public final void setStartCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
        }

        public final String getStartSubdivisionCode() {
            return this.startSubdivisionCode;
        }

        @Override
        public final Builder startSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
            return this;
        }

        public final void setStartSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListGeoLocationsRequest build() {
            return new ListGeoLocationsRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, ListGeoLocationsRequest> {
        public Builder startContinentCode(String var1);

        public Builder startCountryCode(String var1);

        public Builder startSubdivisionCode(String var1);

        public Builder maxItems(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

