/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesByNameRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListHostedZonesByNameRequest> {
    private final String dnsName;
    private final String hostedZoneId;
    private final String maxItems;

    private ListHostedZonesByNameRequest(BuilderImpl builder) {
        super(builder);
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.maxItems = builder.maxItems;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameRequest)) {
            return false;
        }
        ListHostedZonesByNameRequest other = (ListHostedZonesByNameRequest)((Object)obj);
        return Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListHostedZonesByNameRequest").add("DNSName", (Object)this.dnsName()).add("HostedZoneId", (Object)this.hostedZoneId()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DNSName": {
                return Optional.of(clazz.cast(this.dnsName()));
            }
            case "HostedZoneId": {
                return Optional.of(clazz.cast(this.hostedZoneId()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String dnsName;
        private String hostedZoneId;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameRequest model) {
            super(model);
            this.dnsName(model.dnsName);
            this.hostedZoneId(model.hostedZoneId);
            this.maxItems(model.maxItems);
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListHostedZonesByNameRequest build() {
            return new ListHostedZonesByNameRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, ListHostedZonesByNameRequest> {
        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);

        public Builder maxItems(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

