/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTrafficPolicyVersionsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
    private final String id;
    private final String trafficPolicyVersionMarker;
    private final String maxItems;

    private ListTrafficPolicyVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    public String id() {
        return this.id;
    }

    public String trafficPolicyVersionMarker() {
        return this.trafficPolicyVersionMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersionMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsRequest)) {
            return false;
        }
        ListTrafficPolicyVersionsRequest other = (ListTrafficPolicyVersionsRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.trafficPolicyVersionMarker(), other.trafficPolicyVersionMarker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListTrafficPolicyVersionsRequest").add("Id", (Object)this.id()).add("TrafficPolicyVersionMarker", (Object)this.trafficPolicyVersionMarker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "TrafficPolicyVersionMarker": {
                return Optional.of(clazz.cast(this.trafficPolicyVersionMarker()));
            }
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private String trafficPolicyVersionMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsRequest model) {
            super(model);
            this.id(model.id);
            this.trafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            this.maxItems(model.maxItems);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTrafficPolicyVersionMarker() {
            return this.trafficPolicyVersionMarker;
        }

        @Override
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyVersionsRequest build() {
            return new ListTrafficPolicyVersionsRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
        public Builder id(String var1);

        public Builder trafficPolicyVersionMarker(String var1);

        public Builder maxItems(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

