/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.GeoLocation;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetFailover;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetRegion;
import software.amazon.awssdk.services.route53.model.ResourceRecordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceRecordSet
implements ToCopyableBuilder<Builder, ResourceRecordSet> {
    private final String name;
    private final String type;
    private final String setIdentifier;
    private final Long weight;
    private final String region;
    private final GeoLocation geoLocation;
    private final String failover;
    private final Boolean multiValueAnswer;
    private final Long ttl;
    private final List<ResourceRecord> resourceRecords;
    private final AliasTarget aliasTarget;
    private final String healthCheckId;
    private final String trafficPolicyInstanceId;

    private ResourceRecordSet(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.setIdentifier = builder.setIdentifier;
        this.weight = builder.weight;
        this.region = builder.region;
        this.geoLocation = builder.geoLocation;
        this.failover = builder.failover;
        this.multiValueAnswer = builder.multiValueAnswer;
        this.ttl = builder.ttl;
        this.resourceRecords = builder.resourceRecords;
        this.aliasTarget = builder.aliasTarget;
        this.healthCheckId = builder.healthCheckId;
        this.trafficPolicyInstanceId = builder.trafficPolicyInstanceId;
    }

    public String name() {
        return this.name;
    }

    public RRType type() {
        return RRType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String setIdentifier() {
        return this.setIdentifier;
    }

    public Long weight() {
        return this.weight;
    }

    public ResourceRecordSetRegion region() {
        return ResourceRecordSetRegion.fromValue(this.region);
    }

    public String regionAsString() {
        return this.region;
    }

    public GeoLocation geoLocation() {
        return this.geoLocation;
    }

    public ResourceRecordSetFailover failover() {
        return ResourceRecordSetFailover.fromValue(this.failover);
    }

    public String failoverAsString() {
        return this.failover;
    }

    public Boolean multiValueAnswer() {
        return this.multiValueAnswer;
    }

    public Long ttl() {
        return this.ttl;
    }

    public List<ResourceRecord> resourceRecords() {
        return this.resourceRecords;
    }

    public AliasTarget aliasTarget() {
        return this.aliasTarget;
    }

    public String healthCheckId() {
        return this.healthCheckId;
    }

    public String trafficPolicyInstanceId() {
        return this.trafficPolicyInstanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.setIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geoLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiValueAnswer());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRecordSet)) {
            return false;
        }
        ResourceRecordSet other = (ResourceRecordSet)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.setIdentifier(), other.setIdentifier()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.regionAsString(), other.regionAsString()) && Objects.equals(this.geoLocation(), other.geoLocation()) && Objects.equals(this.failoverAsString(), other.failoverAsString()) && Objects.equals(this.multiValueAnswer(), other.multiValueAnswer()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.resourceRecords(), other.resourceRecords()) && Objects.equals(this.aliasTarget(), other.aliasTarget()) && Objects.equals(this.healthCheckId(), other.healthCheckId()) && Objects.equals(this.trafficPolicyInstanceId(), other.trafficPolicyInstanceId());
    }

    public String toString() {
        return ToString.builder((String)"ResourceRecordSet").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("SetIdentifier", (Object)this.setIdentifier()).add("Weight", (Object)this.weight()).add("Region", (Object)this.regionAsString()).add("GeoLocation", (Object)this.geoLocation()).add("Failover", (Object)this.failoverAsString()).add("MultiValueAnswer", (Object)this.multiValueAnswer()).add("TTL", (Object)this.ttl()).add("ResourceRecords", this.resourceRecords()).add("AliasTarget", (Object)this.aliasTarget()).add("HealthCheckId", (Object)this.healthCheckId()).add("TrafficPolicyInstanceId", (Object)this.trafficPolicyInstanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "SetIdentifier": {
                return Optional.of(clazz.cast(this.setIdentifier()));
            }
            case "Weight": {
                return Optional.of(clazz.cast(this.weight()));
            }
            case "Region": {
                return Optional.of(clazz.cast(this.regionAsString()));
            }
            case "GeoLocation": {
                return Optional.of(clazz.cast(this.geoLocation()));
            }
            case "Failover": {
                return Optional.of(clazz.cast(this.failoverAsString()));
            }
            case "MultiValueAnswer": {
                return Optional.of(clazz.cast(this.multiValueAnswer()));
            }
            case "TTL": {
                return Optional.of(clazz.cast(this.ttl()));
            }
            case "ResourceRecords": {
                return Optional.of(clazz.cast(this.resourceRecords()));
            }
            case "AliasTarget": {
                return Optional.of(clazz.cast(this.aliasTarget()));
            }
            case "HealthCheckId": {
                return Optional.of(clazz.cast(this.healthCheckId()));
            }
            case "TrafficPolicyInstanceId": {
                return Optional.of(clazz.cast(this.trafficPolicyInstanceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String setIdentifier;
        private Long weight;
        private String region;
        private GeoLocation geoLocation;
        private String failover;
        private Boolean multiValueAnswer;
        private Long ttl;
        private List<ResourceRecord> resourceRecords;
        private AliasTarget aliasTarget;
        private String healthCheckId;
        private String trafficPolicyInstanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceRecordSet model) {
            this.name(model.name);
            this.type(model.type);
            this.setIdentifier(model.setIdentifier);
            this.weight(model.weight);
            this.region(model.region);
            this.geoLocation(model.geoLocation);
            this.failover(model.failover);
            this.multiValueAnswer(model.multiValueAnswer);
            this.ttl(model.ttl);
            this.resourceRecords(model.resourceRecords);
            this.aliasTarget(model.aliasTarget);
            this.healthCheckId(model.healthCheckId);
            this.trafficPolicyInstanceId(model.trafficPolicyInstanceId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSetIdentifier() {
            return this.setIdentifier;
        }

        @Override
        public final Builder setIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
            return this;
        }

        public final void setSetIdentifier(String setIdentifier) {
            this.setIdentifier = setIdentifier;
        }

        public final Long getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Long weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Long weight) {
            this.weight = weight;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(ResourceRecordSetRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return this.geoLocation != null ? this.geoLocation.toBuilder() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        public final String getFailover() {
            return this.failover;
        }

        @Override
        public final Builder failover(String failover) {
            this.failover = failover;
            return this;
        }

        @Override
        public final Builder failover(ResourceRecordSetFailover failover) {
            this.failover(failover.toString());
            return this;
        }

        public final void setFailover(String failover) {
            this.failover = failover;
        }

        public final Boolean getMultiValueAnswer() {
            return this.multiValueAnswer;
        }

        @Override
        public final Builder multiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
            return this;
        }

        public final void setMultiValueAnswer(Boolean multiValueAnswer) {
            this.multiValueAnswer = multiValueAnswer;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final Collection<ResourceRecord.Builder> getResourceRecords() {
            return this.resourceRecords != null ? (Collection)this.resourceRecords.stream().map(ResourceRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecords(Collection<ResourceRecord> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copy(resourceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(ResourceRecord ... resourceRecords) {
            this.resourceRecords(Arrays.asList(resourceRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecords(Consumer<ResourceRecord.Builder> ... resourceRecords) {
            this.resourceRecords(Stream.of(resourceRecords).map(c -> (ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRecords(Collection<ResourceRecord.BuilderImpl> resourceRecords) {
            this.resourceRecords = ResourceRecordsCopier.copyFromBuilder(resourceRecords);
        }

        public final AliasTarget.Builder getAliasTarget() {
            return this.aliasTarget != null ? this.aliasTarget.toBuilder() : null;
        }

        @Override
        public final Builder aliasTarget(AliasTarget aliasTarget) {
            this.aliasTarget = aliasTarget;
            return this;
        }

        public final void setAliasTarget(AliasTarget.BuilderImpl aliasTarget) {
            this.aliasTarget = aliasTarget != null ? aliasTarget.build() : null;
        }

        public final String getHealthCheckId() {
            return this.healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        public final String getTrafficPolicyInstanceId() {
            return this.trafficPolicyInstanceId;
        }

        @Override
        public final Builder trafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
            return this;
        }

        public final void setTrafficPolicyInstanceId(String trafficPolicyInstanceId) {
            this.trafficPolicyInstanceId = trafficPolicyInstanceId;
        }

        public ResourceRecordSet build() {
            return new ResourceRecordSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceRecordSet> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(RRType var1);

        public Builder setIdentifier(String var1);

        public Builder weight(Long var1);

        public Builder region(String var1);

        public Builder region(ResourceRecordSetRegion var1);

        public Builder geoLocation(GeoLocation var1);

        default public Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return this.geoLocation((GeoLocation)((GeoLocation.Builder)GeoLocation.builder().apply(geoLocation)).build());
        }

        public Builder failover(String var1);

        public Builder failover(ResourceRecordSetFailover var1);

        public Builder multiValueAnswer(Boolean var1);

        public Builder ttl(Long var1);

        public Builder resourceRecords(Collection<ResourceRecord> var1);

        public Builder resourceRecords(ResourceRecord ... var1);

        public Builder resourceRecords(Consumer<ResourceRecord.Builder> ... var1);

        public Builder aliasTarget(AliasTarget var1);

        default public Builder aliasTarget(Consumer<AliasTarget.Builder> aliasTarget) {
            return this.aliasTarget((AliasTarget)((AliasTarget.Builder)AliasTarget.builder().apply(aliasTarget)).build());
        }

        public Builder healthCheckId(String var1);

        public Builder trafficPolicyInstanceId(String var1);
    }
}

