/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.RecordDataCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TestDNSAnswerResponse
extends Route53Response
implements ToCopyableBuilder<Builder, TestDNSAnswerResponse> {
    private final String nameserver;
    private final String recordName;
    private final String recordType;
    private final List<String> recordData;
    private final String responseCode;
    private final String protocol;

    private TestDNSAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.nameserver = builder.nameserver;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.recordData = builder.recordData;
        this.responseCode = builder.responseCode;
        this.protocol = builder.protocol;
    }

    public String nameserver() {
        return this.nameserver;
    }

    public String recordName() {
        return this.recordName;
    }

    public RRType recordType() {
        return RRType.fromValue(this.recordType);
    }

    public String recordTypeAsString() {
        return this.recordType;
    }

    public List<String> recordData() {
        return this.recordData;
    }

    public String responseCode() {
        return this.responseCode;
    }

    public String protocol() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameserver());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordData());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerResponse)) {
            return false;
        }
        TestDNSAnswerResponse other = (TestDNSAnswerResponse)((Object)obj);
        return Objects.equals(this.nameserver(), other.nameserver()) && Objects.equals(this.recordName(), other.recordName()) && Objects.equals(this.recordTypeAsString(), other.recordTypeAsString()) && Objects.equals(this.recordData(), other.recordData()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.protocol(), other.protocol());
    }

    public String toString() {
        return ToString.builder((String)"TestDNSAnswerResponse").add("Nameserver", (Object)this.nameserver()).add("RecordName", (Object)this.recordName()).add("RecordType", (Object)this.recordTypeAsString()).add("RecordData", this.recordData()).add("ResponseCode", (Object)this.responseCode()).add("Protocol", (Object)this.protocol()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Nameserver": {
                return Optional.of(clazz.cast(this.nameserver()));
            }
            case "RecordName": {
                return Optional.of(clazz.cast(this.recordName()));
            }
            case "RecordType": {
                return Optional.of(clazz.cast(this.recordTypeAsString()));
            }
            case "RecordData": {
                return Optional.of(clazz.cast(this.recordData()));
            }
            case "ResponseCode": {
                return Optional.of(clazz.cast(this.responseCode()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String nameserver;
        private String recordName;
        private String recordType;
        private List<String> recordData;
        private String responseCode;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerResponse model) {
            super(model);
            this.nameserver(model.nameserver);
            this.recordName(model.recordName);
            this.recordType(model.recordType);
            this.recordData(model.recordData);
            this.responseCode(model.responseCode);
            this.protocol(model.protocol);
        }

        public final String getNameserver() {
            return this.nameserver;
        }

        @Override
        public final Builder nameserver(String nameserver) {
            this.nameserver = nameserver;
            return this;
        }

        public final void setNameserver(String nameserver) {
            this.nameserver = nameserver;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final Collection<String> getRecordData() {
            return this.recordData;
        }

        @Override
        public final Builder recordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordData(String ... recordData) {
            this.recordData(Arrays.asList(recordData));
            return this;
        }

        public final void setRecordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public TestDNSAnswerResponse build() {
            return new TestDNSAnswerResponse(this);
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    CopyableBuilder<Builder, TestDNSAnswerResponse> {
        public Builder nameserver(String var1);

        public Builder recordName(String var1);

        public Builder recordType(String var1);

        public Builder recordType(RRType var1);

        public Builder recordData(Collection<String> var1);

        public Builder recordData(String ... var1);

        public Builder responseCode(String var1);

        public Builder protocol(String var1);
    }
}

