/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.route53.model.AssociateVPCWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.VPC;

public class AssociateVPCWithHostedZoneRequestMarshaller
implements Marshaller<Request<AssociateVPCWithHostedZoneRequest>, AssociateVPCWithHostedZoneRequest> {
    public Request<AssociateVPCWithHostedZoneRequest> marshall(AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest) {
        if (associateVPCWithHostedZoneRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)associateVPCWithHostedZoneRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/associatevpc";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", associateVPCWithHostedZoneRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("AssociateVPCWithHostedZoneRequest");
            VPC vpc = associateVPCWithHostedZoneRequest.vpc();
            if (vpc != null) {
                xmlWriter.startElement("VPC");
                if (vpc.vpcRegionAsString() != null) {
                    xmlWriter.startElement("VPCRegion").value(vpc.vpcRegionAsString()).endElement();
                }
                if (vpc.vpcId() != null) {
                    xmlWriter.startElement("VPCId").value(vpc.vpcId()).endElement();
                }
                xmlWriter.endElement();
            }
            if (associateVPCWithHostedZoneRequest.comment() != null) {
                xmlWriter.startElement("Comment").value(associateVPCWithHostedZoneRequest.comment()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

