/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;

public class CreateTrafficPolicyInstanceRequestMarshaller
implements Marshaller<Request<CreateTrafficPolicyInstanceRequest>, CreateTrafficPolicyInstanceRequest> {
    public Request<CreateTrafficPolicyInstanceRequest> marshall(CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {
        if (createTrafficPolicyInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createTrafficPolicyInstanceRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/trafficpolicyinstance";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateTrafficPolicyInstanceRequest");
            if (createTrafficPolicyInstanceRequest.hostedZoneId() != null) {
                xmlWriter.startElement("HostedZoneId").value(createTrafficPolicyInstanceRequest.hostedZoneId()).endElement();
            }
            if (createTrafficPolicyInstanceRequest.name() != null) {
                xmlWriter.startElement("Name").value(createTrafficPolicyInstanceRequest.name()).endElement();
            }
            if (createTrafficPolicyInstanceRequest.ttl() != null) {
                xmlWriter.startElement("TTL").value((Object)createTrafficPolicyInstanceRequest.ttl()).endElement();
            }
            if (createTrafficPolicyInstanceRequest.trafficPolicyId() != null) {
                xmlWriter.startElement("TrafficPolicyId").value(createTrafficPolicyInstanceRequest.trafficPolicyId()).endElement();
            }
            if (createTrafficPolicyInstanceRequest.trafficPolicyVersion() != null) {
                xmlWriter.startElement("TrafficPolicyVersion").value((Object)createTrafficPolicyInstanceRequest.trafficPolicyVersion()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

