/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CheckDomainTransferabilityRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, CheckDomainTransferabilityRequest> {
    private final String domainName;
    private final String authCode;

    private CheckDomainTransferabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.authCode = builder.authCode;
    }

    public String domainName() {
        return this.domainName;
    }

    public String authCode() {
        return this.authCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainTransferabilityRequest)) {
            return false;
        }
        CheckDomainTransferabilityRequest other = (CheckDomainTransferabilityRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.authCode(), other.authCode());
    }

    public String toString() {
        return ToString.builder((String)"CheckDomainTransferabilityRequest").add("DomainName", (Object)this.domainName()).add("AuthCode", (Object)this.authCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AuthCode": {
                return Optional.of(clazz.cast(this.authCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String authCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainTransferabilityRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.authCode(model.authCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAuthCode() {
            return this.authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainTransferabilityRequest build() {
            return new CheckDomainTransferabilityRequest(this);
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    CopyableBuilder<Builder, CheckDomainTransferabilityRequest> {
        public Builder domainName(String var1);

        public Builder authCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

