/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;

public class ListDomainsIterable
implements SdkIterable<ListDomainsResponse> {
    private final Route53DomainsClient client;
    private final ListDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainsIterable(Route53DomainsClient client, ListDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public Iterator<ListDomainsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DomainSummary> domains() {
        Function<ListDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domains() != null) {
                return response.domains().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListDomainsIterable resume(ListDomainsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDomainsIterable(this.client, (ListDomainsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.nextPageMarker()).build()));
        }
        return new ListDomainsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDomainsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDomainsResponseFetcher
    implements SyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return previousPage.nextPageMarker() != null;
        }

        public ListDomainsResponse nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsIterable.this.client.listDomains(ListDomainsIterable.this.firstRequest);
            }
            return ListDomainsIterable.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsIterable.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

