/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BillingRecordMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operation").isBinary(false).build();
    private static final MarshallingInfo<String> INVOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvoiceId").isBinary(false).build();
    private static final MarshallingInfo<Instant> BILLDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BillDate").isBinary(false).build();
    private static final MarshallingInfo<Double> PRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Price").isBinary(false).build();
    private static final BillingRecordMarshaller INSTANCE = new BillingRecordMarshaller();

    private BillingRecordMarshaller() {
    }

    public static BillingRecordMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BillingRecord billingRecord, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)billingRecord, (String)"billingRecord");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)billingRecord.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.operationAsString(), OPERATION_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.invoiceId(), INVOICEID_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.billDate(), BILLDATE_BINDING);
            protocolMarshaller.marshall((Object)billingRecord.price(), PRICE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

