/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.DomainSuggestion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DomainSuggestionMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Availability").isBinary(false).build();
    private static final DomainSuggestionMarshaller INSTANCE = new DomainSuggestionMarshaller();

    private DomainSuggestionMarshaller() {
    }

    public static DomainSuggestionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DomainSuggestion domainSuggestion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)domainSuggestion, (String)"domainSuggestion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)domainSuggestion.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)domainSuggestion.availability(), AVAILABILITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

