/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RenewDomainRequestModelMarshaller {
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATIONINYEARS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationInYears").isBinary(false).build();
    private static final MarshallingInfo<Integer> CURRENTEXPIRYYEAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentExpiryYear").isBinary(false).build();
    private static final RenewDomainRequestModelMarshaller INSTANCE = new RenewDomainRequestModelMarshaller();

    private RenewDomainRequestModelMarshaller() {
    }

    public static RenewDomainRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RenewDomainRequest renewDomainRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)renewDomainRequest), (String)"renewDomainRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)renewDomainRequest.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)renewDomainRequest.durationInYears(), DURATIONINYEARS_BINDING);
            protocolMarshaller.marshall((Object)renewDomainRequest.currentExpiryYear(), CURRENTEXPIRYYEAR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

