/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHostedZoneRequest extends Route53Request implements
        ToCopyableBuilder<CreateHostedZoneRequest.Builder, CreateHostedZoneRequest> {
    private final String name;

    private final VPC vpc;

    private final String callerReference;

    private final HostedZoneConfig hostedZoneConfig;

    private final String delegationSetId;

    private CreateHostedZoneRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.vpc = builder.vpc;
        this.callerReference = builder.callerReference;
        this.hostedZoneConfig = builder.hostedZoneConfig;
        this.delegationSetId = builder.delegationSetId;
    }

    /**
     * <p>
     * The name of the domain. For resource record types that include a domain name, specify a fully qualified domain
     * name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that the domain
     * name is fully qualified. This means that Amazon Route 53 treats <i>www.example.com</i> (without a trailing dot)
     * and <i>www.example.com.</i> (with a trailing dot) as identical.
     * </p>
     * <p>
     * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If your
     * domain name is registered with a registrar other than Amazon Route 53, change the name servers for your domain to
     * the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in <code>DelegationSet</code>.
     * </p>
     * 
     * @return The name of the domain. For resource record types that include a domain name, specify a fully qualified
     *         domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes
     *         that the domain name is fully qualified. This means that Amazon Route 53 treats <i>www.example.com</i>
     *         (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.</p>
     *         <p>
     *         If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If
     *         your domain name is registered with a registrar other than Amazon Route 53, change the name servers for
     *         your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
     *         <code>DelegationSet</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're associating
     * with this hosted zone.
     * </p>
     * <p>
     * You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon VPCs
     * with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted zone.
     * </p>
     * 
     * @return (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
     *         associating with this hosted zone.</p>
     *         <p>
     *         You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon
     *         VPCs with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    /**
     * <p>
     * A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to be
     * retried without the risk of executing the operation twice. You must use a unique <code>CallerReference</code>
     * string every time you submit a <code>CreateHostedZone</code> request. <code>CallerReference</code> can be any
     * unique string, for example, a date/time stamp.
     * </p>
     * 
     * @return A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests
     *         to be retried without the risk of executing the operation twice. You must use a unique
     *         <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
     *         <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * (Optional) A complex type that contains the following optional values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For public and private hosted zones, an optional comment
     * </p>
     * </li>
     * <li>
     * <p>
     * For private hosted zones, an optional <code>PrivateZone</code> element
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code> and
     * the other elements.
     * </p>
     * 
     * @return (Optional) A complex type that contains the following optional values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For public and private hosted zones, an optional comment
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For private hosted zones, an optional <code>PrivateZone</code> element
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you don't specify a comment or the <code>PrivateZone</code> element, omit
     *         <code>HostedZoneConfig</code> and the other elements.
     */
    public HostedZoneConfig hostedZoneConfig() {
        return hostedZoneConfig;
    }

    /**
     * <p>
     * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53 assigned to
     * the reusable delegation set when you created it. For more information about reusable delegation sets, see
     * <a>CreateReusableDelegationSet</a>.
     * </p>
     * 
     * @return If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
     *         assigned to the reusable delegation set when you created it. For more information about reusable
     *         delegation sets, see <a>CreateReusableDelegationSet</a>.
     */
    public String delegationSetId() {
        return delegationSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(delegationSetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneRequest)) {
            return false;
        }
        CreateHostedZoneRequest other = (CreateHostedZoneRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(vpc(), other.vpc())
                && Objects.equals(callerReference(), other.callerReference())
                && Objects.equals(hostedZoneConfig(), other.hostedZoneConfig())
                && Objects.equals(delegationSetId(), other.delegationSetId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateHostedZoneRequest").add("Name", name()).add("VPC", vpc())
                .add("CallerReference", callerReference()).add("HostedZoneConfig", hostedZoneConfig())
                .add("DelegationSetId", delegationSetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "HostedZoneConfig":
            return Optional.ofNullable(clazz.cast(hostedZoneConfig()));
        case "DelegationSetId":
            return Optional.ofNullable(clazz.cast(delegationSetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, CreateHostedZoneRequest> {
        /**
         * <p>
         * The name of the domain. For resource record types that include a domain name, specify a fully qualified
         * domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route 53 assumes that
         * the domain name is fully qualified. This means that Amazon Route 53 treats <i>www.example.com</i> (without a
         * trailing dot) and <i>www.example.com.</i> (with a trailing dot) as identical.
         * </p>
         * <p>
         * If you're creating a public hosted zone, this is the name you have registered with your DNS registrar. If
         * your domain name is registered with a registrar other than Amazon Route 53, change the name servers for your
         * domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
         * <code>DelegationSet</code>.
         * </p>
         * 
         * @param name
         *        The name of the domain. For resource record types that include a domain name, specify a fully
         *        qualified domain name, for example, <i>www.example.com</i>. The trailing dot is optional; Amazon Route
         *        53 assumes that the domain name is fully qualified. This means that Amazon Route 53 treats
         *        <i>www.example.com</i> (without a trailing dot) and <i>www.example.com.</i> (with a trailing dot) as
         *        identical.</p>
         *        <p>
         *        If you're creating a public hosted zone, this is the name you have registered with your DNS registrar.
         *        If your domain name is registered with a registrar other than Amazon Route 53, change the name servers
         *        for your domain to the set of <code>NameServers</code> that <code>CreateHostedZone</code> returns in
         *        <code>DelegationSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         * associating with this hosted zone.
         * </p>
         * <p>
         * You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon
         * VPCs with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted zone.
         * </p>
         * 
         * @param vpc
         *        (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         *        associating with this hosted zone.</p>
         *        <p>
         *        You can specify only one Amazon VPC when you create a private hosted zone. To associate additional
         *        Amazon VPCs with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * (Private hosted zones only) A complex type that contains information about the Amazon VPC that you're
         * associating with this hosted zone.
         * </p>
         * <p>
         * You can specify only one Amazon VPC when you create a private hosted zone. To associate additional Amazon
         * VPCs with the hosted zone, use <a>AssociateVPCWithHostedZone</a> after you create a hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link VPC.Builder} avoiding the need to create one
         * manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }

        /**
         * <p>
         * A unique string that identifies the request and that allows failed <code>CreateHostedZone</code> requests to
         * be retried without the risk of executing the operation twice. You must use a unique
         * <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
         * <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
         * </p>
         * 
         * @param callerReference
         *        A unique string that identifies the request and that allows failed <code>CreateHostedZone</code>
         *        requests to be retried without the risk of executing the operation twice. You must use a unique
         *        <code>CallerReference</code> string every time you submit a <code>CreateHostedZone</code> request.
         *        <code>CallerReference</code> can be any unique string, for example, a date/time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * (Optional) A complex type that contains the following optional values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For public and private hosted zones, an optional comment
         * </p>
         * </li>
         * <li>
         * <p>
         * For private hosted zones, an optional <code>PrivateZone</code> element
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code>
         * and the other elements.
         * </p>
         * 
         * @param hostedZoneConfig
         *        (Optional) A complex type that contains the following optional values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For public and private hosted zones, an optional comment
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For private hosted zones, an optional <code>PrivateZone</code> element
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you don't specify a comment or the <code>PrivateZone</code> element, omit
         *        <code>HostedZoneConfig</code> and the other elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig);

        /**
         * <p>
         * (Optional) A complex type that contains the following optional values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For public and private hosted zones, an optional comment
         * </p>
         * </li>
         * <li>
         * <p>
         * For private hosted zones, an optional <code>PrivateZone</code> element
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you don't specify a comment or the <code>PrivateZone</code> element, omit <code>HostedZoneConfig</code>
         * and the other elements.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZoneConfig.Builder} avoiding the need to
         * create one manually via {@link HostedZoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #hostedZoneConfig(HostedZoneConfig)}.
         * 
         * @param hostedZoneConfig
         *        a consumer that will call methods on {@link HostedZoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostedZoneConfig(HostedZoneConfig)
         */
        default Builder hostedZoneConfig(Consumer<HostedZoneConfig.Builder> hostedZoneConfig) {
            return hostedZoneConfig(HostedZoneConfig.builder().applyMutation(hostedZoneConfig).build());
        }

        /**
         * <p>
         * If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
         * assigned to the reusable delegation set when you created it. For more information about reusable delegation
         * sets, see <a>CreateReusableDelegationSet</a>.
         * </p>
         * 
         * @param delegationSetId
         *        If you want to associate a reusable delegation set with this hosted zone, the ID that Amazon Route 53
         *        assigned to the reusable delegation set when you created it. For more information about reusable
         *        delegation sets, see <a>CreateReusableDelegationSet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSetId(String delegationSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String name;

        private VPC vpc;

        private String callerReference;

        private HostedZoneConfig hostedZoneConfig;

        private String delegationSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneRequest model) {
            super(model);
            name(model.name);
            vpc(model.vpc);
            callerReference(model.callerReference);
            hostedZoneConfig(model.hostedZoneConfig);
            delegationSetId(model.delegationSetId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final VPC.Builder getVPC() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getHostedZoneConfig() {
            return hostedZoneConfig != null ? hostedZoneConfig.toBuilder() : null;
        }

        @Override
        public final Builder hostedZoneConfig(HostedZoneConfig hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig;
            return this;
        }

        public final void setHostedZoneConfig(HostedZoneConfig.BuilderImpl hostedZoneConfig) {
            this.hostedZoneConfig = hostedZoneConfig != null ? hostedZoneConfig.build() : null;
        }

        public final String getDelegationSetId() {
            return delegationSetId;
        }

        @Override
        public final Builder delegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
            return this;
        }

        public final void setDelegationSetId(String delegationSetId) {
            this.delegationSetId = delegationSetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHostedZoneRequest build() {
            return new CreateHostedZoneRequest(this);
        }
    }
}
