/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information from a <code>CreateVPCAssociationAuthorization</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcAssociationAuthorizationResponse extends Route53Response implements
        ToCopyableBuilder<CreateVpcAssociationAuthorizationResponse.Builder, CreateVpcAssociationAuthorizationResponse> {
    private final String hostedZoneId;

    private final VPC vpc;

    private CreateVpcAssociationAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The ID of the hosted zone that you authorized associating a VPC with.
     * </p>
     * 
     * @return The ID of the hosted zone that you authorized associating a VPC with.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The VPC that you authorized associating with a hosted zone.
     * </p>
     * 
     * @return The VPC that you authorized associating with a hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcAssociationAuthorizationResponse)) {
            return false;
        }
        CreateVpcAssociationAuthorizationResponse other = (CreateVpcAssociationAuthorizationResponse) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(vpc(), other.vpc());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpcAssociationAuthorizationResponse").add("HostedZoneId", hostedZoneId())
                .add("VPC", vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "VPC":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, CreateVpcAssociationAuthorizationResponse> {
        /**
         * <p>
         * The ID of the hosted zone that you authorized associating a VPC with.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you authorized associating a VPC with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The VPC that you authorized associating with a hosted zone.
         * </p>
         * 
         * @param vpc
         *        The VPC that you authorized associating with a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * The VPC that you authorized associating with a hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link VPC.Builder} avoiding the need to create one
         * manually via {@link VPC#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPC.Builder#build()} is called immediately and its result is
         * passed to {@link #vpc(VPC)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VPC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VPC)
         */
        default Builder vpc(Consumer<VPC.Builder> vpc) {
            return vpc(VPC.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcAssociationAuthorizationResponse model) {
            super(model);
            hostedZoneId(model.hostedZoneId);
            vpc(model.vpc);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC.Builder getVPC() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public CreateVpcAssociationAuthorizationResponse build() {
            return new CreateVpcAssociationAuthorizationResponse(this);
        }
    }
}
