/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete a specified traffic policy version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteTrafficPolicyRequest extends Route53Request implements
        ToCopyableBuilder<DeleteTrafficPolicyRequest.Builder, DeleteTrafficPolicyRequest> {
    private final String id;

    private final Integer version;

    private DeleteTrafficPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the traffic policy that you want to delete.
     * </p>
     * 
     * @return The ID of the traffic policy that you want to delete.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The version number of the traffic policy that you want to delete.
     * </p>
     * 
     * @return The version number of the traffic policy that you want to delete.
     */
    public Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTrafficPolicyRequest)) {
            return false;
        }
        DeleteTrafficPolicyRequest other = (DeleteTrafficPolicyRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteTrafficPolicyRequest").add("Id", id()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, DeleteTrafficPolicyRequest> {
        /**
         * <p>
         * The ID of the traffic policy that you want to delete.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version number of the traffic policy that you want to delete.
         * </p>
         * 
         * @param version
         *        The version number of the traffic policy that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTrafficPolicyRequest model) {
            super(model);
            id(model.id);
            version(model.version);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteTrafficPolicyRequest build() {
            return new DeleteTrafficPolicyRequest(this);
        }
    }
}
