/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get information about a specified health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthCheckRequest extends Route53Request implements
        ToCopyableBuilder<GetHealthCheckRequest.Builder, GetHealthCheckRequest> {
    private final String healthCheckId;

    private GetHealthCheckRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheckId = builder.healthCheckId;
    }

    /**
     * <p>
     * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update a
     * resource record set, you use this value to specify which health check to use. The value can be up to 64
     * characters long.
     * </p>
     * 
     * @return The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or
     *         update a resource record set, you use this value to specify which health check to use. The value can be
     *         up to 64 characters long.
     */
    public String healthCheckId() {
        return healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckRequest)) {
            return false;
        }
        GetHealthCheckRequest other = (GetHealthCheckRequest) obj;
        return Objects.equals(healthCheckId(), other.healthCheckId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHealthCheckRequest").add("HealthCheckId", healthCheckId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckId":
            return Optional.ofNullable(clazz.cast(healthCheckId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, GetHealthCheckRequest> {
        /**
         * <p>
         * The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or update
         * a resource record set, you use this value to specify which health check to use. The value can be up to 64
         * characters long.
         * </p>
         * 
         * @param healthCheckId
         *        The identifier that Amazon Route 53 assigned to the health check when you created it. When you add or
         *        update a resource record set, you use this value to specify which health check to use. The value can
         *        be up to 64 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckRequest model) {
            super(model);
            healthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHealthCheckRequest build() {
            return new GetHealthCheckRequest(this);
        }
    }
}
