/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheck</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHealthCheckStatusResponse extends Route53Response implements
        ToCopyableBuilder<GetHealthCheckStatusResponse.Builder, GetHealthCheckStatusResponse> {
    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckStatusResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    /**
     * <p>
     * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that
     * is reporting a status about the health check endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
     *         checker that is reporting a status about the health check endpoint.
     */
    public List<HealthCheckObservation> healthCheckObservations() {
        return healthCheckObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckObservations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusResponse)) {
            return false;
        }
        GetHealthCheckStatusResponse other = (GetHealthCheckStatusResponse) obj;
        return Objects.equals(healthCheckObservations(), other.healthCheckObservations());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHealthCheckStatusResponse").add("HealthCheckObservations", healthCheckObservations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HealthCheckObservations":
            return Optional.ofNullable(clazz.cast(healthCheckObservations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Response.Builder, CopyableBuilder<Builder, GetHealthCheckStatusResponse> {
        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HealthCheckObservation>.Builder} avoiding
         * the need to create one manually via {@link List<HealthCheckObservation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HealthCheckObservation>.Builder#build()} is called
         * immediately and its result is passed to {@link #healthCheckObservations(List<HealthCheckObservation>)}.
         * 
         * @param healthCheckObservations
         *        a consumer that will call methods on {@link List<HealthCheckObservation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckObservations(List<HealthCheckObservation>)
         */
        Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<HealthCheckObservation> healthCheckObservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusResponse model) {
            super(model);
            healthCheckObservations(model.healthCheckObservations);
        }

        public final Collection<HealthCheckObservation.Builder> getHealthCheckObservations() {
            return healthCheckObservations != null ? healthCheckObservations.stream().map(HealthCheckObservation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder>... healthCheckObservations) {
            healthCheckObservations(Stream.of(healthCheckObservations)
                    .map(c -> HealthCheckObservation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation.BuilderImpl> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copyFromBuilder(healthCheckObservations);
        }

        @Override
        public GetHealthCheckStatusResponse build() {
            return new GetHealthCheckStatusResponse(this);
        }
    }
}
