/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostedZoneLimitRequest extends Route53Request implements
        ToCopyableBuilder<GetHostedZoneLimitRequest.Builder, GetHostedZoneLimitRequest> {
    private final String type;

    private final String hostedZoneId;

    private GetHostedZoneLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * The limit that you want to get. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the specified
     * private hosted zone.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HostedZoneLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The limit that you want to get. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
     *         zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
     *         specified private hosted zone.
     *         </p>
     *         </li>
     * @see HostedZoneLimitType
     */
    public HostedZoneLimitType type() {
        return HostedZoneLimitType.fromValue(type);
    }

    /**
     * <p>
     * The limit that you want to get. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the specified
     * private hosted zone.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link HostedZoneLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The limit that you want to get. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
     *         zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
     *         specified private hosted zone.
     *         </p>
     *         </li>
     * @see HostedZoneLimitType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want to get a limit for.
     * </p>
     * 
     * @return The ID of the hosted zone that you want to get a limit for.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitRequest)) {
            return false;
        }
        GetHostedZoneLimitRequest other = (GetHostedZoneLimitRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostedZoneLimitRequest").add("Type", typeAsString()).add("HostedZoneId", hostedZoneId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends Route53Request.Builder, CopyableBuilder<Builder, GetHostedZoneLimitRequest> {
        /**
         * <p>
         * The limit that you want to get. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         * specified private hosted zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you want to get. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
         *        zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         *        specified private hosted zone.
         *        </p>
         *        </li>
         * @see HostedZoneLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneLimitType
         */
        Builder type(String type);

        /**
         * <p>
         * The limit that you want to get. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         * specified private hosted zone.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you want to get. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_RRSETS_BY_ZONE</b>: The maximum number of records that you can create in the specified hosted
         *        zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_VPCS_ASSOCIATED_BY_TYPE</b>: The maximum number of Amazon VPCs that you can associate with the
         *        specified private hosted zone.
         *        </p>
         *        </li>
         * @see HostedZoneLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostedZoneLimitType
         */
        Builder type(HostedZoneLimitType type);

        /**
         * <p>
         * The ID of the hosted zone that you want to get a limit for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want to get a limit for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String type;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitRequest model) {
            super(model);
            type(model.type);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(HostedZoneLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHostedZoneLimitRequest build() {
            return new GetHostedZoneLimitRequest(this);
        }
    }
}
