/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains general information about the hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostedZone implements ToCopyableBuilder<HostedZone.Builder, HostedZone> {
    private final String id;

    private final String name;

    private final String callerReference;

    private final HostedZoneConfig config;

    private final Long resourceRecordSetCount;

    private final LinkedService linkedService;

    private HostedZone(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.callerReference = builder.callerReference;
        this.config = builder.config;
        this.resourceRecordSetCount = builder.resourceRecordSetCount;
        this.linkedService = builder.linkedService;
    }

    /**
     * <p>
     * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     * </p>
     * 
     * @return The ID that Amazon Route 53 assigned to the hosted zone when you created it.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     * registrar.
     * </p>
     * <p>
     * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and <code>-</code>
     * (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
     * </p>
     * 
     * @return The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     *         registrar.</p>
     *         <p>
     *         For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
     *         <code>-</code> (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     * </p>
     * 
     * @return The value that you specified for <code>CallerReference</code> when you created the hosted zone.
     */
    public String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted the
     * <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code> and
     * <code>Comment</code> elements don't appear in the response.
     * </p>
     * 
     * @return A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
     *         omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
     *         <code>Config</code> and <code>Comment</code> elements don't appear in the response.
     */
    public HostedZoneConfig config() {
        return config;
    }

    /**
     * <p>
     * The number of resource record sets in the hosted zone.
     * </p>
     * 
     * @return The number of resource record sets in the hosted zone.
     */
    public Long resourceRecordSetCount() {
        return resourceRecordSetCount;
    }

    /**
     * <p>
     * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted zone
     * is created by another service, you can't edit or delete it using Amazon Route 53.
     * </p>
     * 
     * @return If the hosted zone was created by another service, the service that created the hosted zone. When a
     *         hosted zone is created by another service, you can't edit or delete it using Amazon Route 53.
     */
    public LinkedService linkedService() {
        return linkedService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        hashCode = 31 * hashCode + Objects.hashCode(resourceRecordSetCount());
        hashCode = 31 * hashCode + Objects.hashCode(linkedService());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZone)) {
            return false;
        }
        HostedZone other = (HostedZone) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(callerReference(), other.callerReference()) && Objects.equals(config(), other.config())
                && Objects.equals(resourceRecordSetCount(), other.resourceRecordSetCount())
                && Objects.equals(linkedService(), other.linkedService());
    }

    @Override
    public String toString() {
        return ToString.builder("HostedZone").add("Id", id()).add("Name", name()).add("CallerReference", callerReference())
                .add("Config", config()).add("ResourceRecordSetCount", resourceRecordSetCount())
                .add("LinkedService", linkedService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "ResourceRecordSetCount":
            return Optional.ofNullable(clazz.cast(resourceRecordSetCount()));
        case "LinkedService":
            return Optional.ofNullable(clazz.cast(linkedService()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HostedZone> {
        /**
         * <p>
         * The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * </p>
         * 
         * @param id
         *        The ID that Amazon Route 53 assigned to the hosted zone when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
         * registrar.
         * </p>
         * <p>
         * For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         * <code>-</code> (hyphen) and how to specify internationalized domain names, see <a>CreateHostedZone</a>.
         * </p>
         * 
         * @param name
         *        The name of the domain. For public hosted zones, this is the name that you have registered with your
         *        DNS registrar.</p>
         *        <p>
         *        For information about how to specify characters other than <code>a-z</code>, <code>0-9</code>, and
         *        <code>-</code> (hyphen) and how to specify internationalized domain names, see
         *        <a>CreateHostedZone</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * </p>
         * 
         * @param callerReference
         *        The value that you specified for <code>CallerReference</code> when you created the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted
         * the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code>
         * and <code>Comment</code> elements don't appear in the response.
         * </p>
         * 
         * @param config
         *        A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you
         *        omitted the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the
         *        <code>Config</code> and <code>Comment</code> elements don't appear in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HostedZoneConfig config);

        /**
         * <p>
         * A complex type that includes the <code>Comment</code> and <code>PrivateZone</code> elements. If you omitted
         * the <code>HostedZoneConfig</code> and <code>Comment</code> elements from the request, the <code>Config</code>
         * and <code>Comment</code> elements don't appear in the response.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZoneConfig.Builder} avoiding the need to
         * create one manually via {@link HostedZoneConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZoneConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #config(HostedZoneConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link HostedZoneConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(HostedZoneConfig)
         */
        default Builder config(Consumer<HostedZoneConfig.Builder> config) {
            return config(HostedZoneConfig.builder().applyMutation(config).build());
        }

        /**
         * <p>
         * The number of resource record sets in the hosted zone.
         * </p>
         * 
         * @param resourceRecordSetCount
         *        The number of resource record sets in the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceRecordSetCount(Long resourceRecordSetCount);

        /**
         * <p>
         * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted
         * zone is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * 
         * @param linkedService
         *        If the hosted zone was created by another service, the service that created the hosted zone. When a
         *        hosted zone is created by another service, you can't edit or delete it using Amazon Route 53.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkedService(LinkedService linkedService);

        /**
         * <p>
         * If the hosted zone was created by another service, the service that created the hosted zone. When a hosted
         * zone is created by another service, you can't edit or delete it using Amazon Route 53.
         * </p>
         * This is a convenience that creates an instance of the {@link LinkedService.Builder} avoiding the need to
         * create one manually via {@link LinkedService#builder()}.
         *
         * When the {@link Consumer} completes, {@link LinkedService.Builder#build()} is called immediately and its
         * result is passed to {@link #linkedService(LinkedService)}.
         * 
         * @param linkedService
         *        a consumer that will call methods on {@link LinkedService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkedService(LinkedService)
         */
        default Builder linkedService(Consumer<LinkedService.Builder> linkedService) {
            return linkedService(LinkedService.builder().applyMutation(linkedService).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String callerReference;

        private HostedZoneConfig config;

        private Long resourceRecordSetCount;

        private LinkedService linkedService;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZone model) {
            id(model.id);
            name(model.name);
            callerReference(model.callerReference);
            config(model.config);
            resourceRecordSetCount(model.resourceRecordSetCount);
            linkedService(model.linkedService);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCallerReference() {
            return callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HostedZoneConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        @Override
        public final Builder config(HostedZoneConfig config) {
            this.config = config;
            return this;
        }

        public final void setConfig(HostedZoneConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        public final Long getResourceRecordSetCount() {
            return resourceRecordSetCount;
        }

        @Override
        public final Builder resourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
            return this;
        }

        public final void setResourceRecordSetCount(Long resourceRecordSetCount) {
            this.resourceRecordSetCount = resourceRecordSetCount;
        }

        public final LinkedService.Builder getLinkedService() {
            return linkedService != null ? linkedService.toBuilder() : null;
        }

        @Override
        public final Builder linkedService(LinkedService linkedService) {
            this.linkedService = linkedService;
            return this;
        }

        public final void setLinkedService(LinkedService.BuilderImpl linkedService) {
            this.linkedService = linkedService != null ? linkedService.build() : null;
        }

        @Override
        public HostedZone build() {
            return new HostedZone(this);
        }
    }
}
