/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a configuration for DNS query logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryLoggingConfig implements ToCopyableBuilder<QueryLoggingConfig.Builder, QueryLoggingConfig> {
    private final String id;

    private final String hostedZoneId;

    private final String cloudWatchLogsLogGroupArn;

    private QueryLoggingConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.hostedZoneId = builder.hostedZoneId;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
    }

    /**
     * <p>
     * The ID for a configuration for DNS query logging.
     * </p>
     * 
     * @return The ID for a configuration for DNS query logging.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the hosted zone that CloudWatch Logs is logging queries for.
     * </p>
     * 
     * @return The ID of the hosted zone that CloudWatch Logs is logging queries for.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs
     *         to.
     */
    public String cloudWatchLogsLogGroupArn() {
        return cloudWatchLogsLogGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsLogGroupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLoggingConfig)) {
            return false;
        }
        QueryLoggingConfig other = (QueryLoggingConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(hostedZoneId(), other.hostedZoneId())
                && Objects.equals(cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("QueryLoggingConfig").add("Id", id()).add("HostedZoneId", hostedZoneId())
                .add("CloudWatchLogsLogGroupArn", cloudWatchLogsLogGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "HostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "CloudWatchLogsLogGroupArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsLogGroupArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, QueryLoggingConfig> {
        /**
         * <p>
         * The ID for a configuration for DNS query logging.
         * </p>
         * 
         * @param id
         *        The ID for a configuration for DNS query logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the hosted zone that CloudWatch Logs is logging queries for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that CloudWatch Logs is logging queries for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing logs to.
         * </p>
         * 
         * @param cloudWatchLogsLogGroupArn
         *        The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon Route 53 is publishing
         *        logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String hostedZoneId;

        private String cloudWatchLogsLogGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLoggingConfig model) {
            id(model.id);
            hostedZoneId(model.hostedZoneId);
            cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        @Override
        public QueryLoggingConfig build() {
            return new QueryLoggingConfig(this);
        }
    }
}
