/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a tag that you want to add or edit for the specified health check or
 * hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tag implements ToCopyableBuilder<Tag.Builder, Tag> {
    private final String key;

    private final String value;

    private Tag(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The value of <code>Key</code> depends on the operation that you want to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Add a tag to a health check or hosted zone</b>: <code>Key</code> is the name that you want to give the new
     * tag.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Edit a tag</b>: <code>Key</code> is the name of the tag that you want to change the <code>Value</code> for.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> Delete a key</b>: <code>Key</code> is the name of the tag you want to remove.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Give a name to a health check</b>: Edit the default <code>Name</code> tag. In the Amazon Route 53 console, the
     * list of your health checks includes a <b>Name</b> column that lets you see the name that you've given to each
     * health check.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The value of <code>Key</code> depends on the operation that you want to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Add a tag to a health check or hosted zone</b>: <code>Key</code> is the name that you want to give the
     *         new tag.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Edit a tag</b>: <code>Key</code> is the name of the tag that you want to change the <code>Value</code>
     *         for.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> Delete a key</b>: <code>Key</code> is the name of the tag you want to remove.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Give a name to a health check</b>: Edit the default <code>Name</code> tag. In the Amazon Route 53
     *         console, the list of your health checks includes a <b>Name</b> column that lets you see the name that
     *         you've given to each health check.
     *         </p>
     *         </li>
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value of <code>Value</code> depends on the operation that you want to perform:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Add a tag to a health check or hosted zone</b>: <code>Value</code> is the value that you want to give the new
     * tag.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Edit a tag</b>: <code>Value</code> is the new value that you want to assign the tag.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The value of <code>Value</code> depends on the operation that you want to perform:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Add a tag to a health check or hosted zone</b>: <code>Value</code> is the value that you want to give
     *         the new tag.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Edit a tag</b>: <code>Value</code> is the new value that you want to assign the tag.
     *         </p>
     *         </li>
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    @Override
    public String toString() {
        return ToString.builder("Tag").add("Key", key()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Tag> {
        /**
         * <p>
         * The value of <code>Key</code> depends on the operation that you want to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Add a tag to a health check or hosted zone</b>: <code>Key</code> is the name that you want to give the new
         * tag.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Edit a tag</b>: <code>Key</code> is the name of the tag that you want to change the <code>Value</code>
         * for.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> Delete a key</b>: <code>Key</code> is the name of the tag you want to remove.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Give a name to a health check</b>: Edit the default <code>Name</code> tag. In the Amazon Route 53 console,
         * the list of your health checks includes a <b>Name</b> column that lets you see the name that you've given to
         * each health check.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The value of <code>Key</code> depends on the operation that you want to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Add a tag to a health check or hosted zone</b>: <code>Key</code> is the name that you want to give
         *        the new tag.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Edit a tag</b>: <code>Key</code> is the name of the tag that you want to change the
         *        <code>Value</code> for.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> Delete a key</b>: <code>Key</code> is the name of the tag you want to remove.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Give a name to a health check</b>: Edit the default <code>Name</code> tag. In the Amazon Route 53
         *        console, the list of your health checks includes a <b>Name</b> column that lets you see the name that
         *        you've given to each health check.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of <code>Value</code> depends on the operation that you want to perform:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Add a tag to a health check or hosted zone</b>: <code>Value</code> is the value that you want to give the
         * new tag.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Edit a tag</b>: <code>Value</code> is the new value that you want to assign the tag.
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        The value of <code>Value</code> depends on the operation that you want to perform:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Add a tag to a health check or hosted zone</b>: <code>Value</code> is the value that you want to
         *        give the new tag.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Edit a tag</b>: <code>Value</code> is the new value that you want to assign the tag.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Tag build() {
            return new Tag(this);
        }
    }
}
