/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * TestDnsAnswerResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TestDnsAnswerResponseUnmarshaller implements Unmarshaller<TestDnsAnswerResponse, StaxUnmarshallerContext> {

    public TestDnsAnswerResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        TestDnsAnswerResponse.Builder testDnsAnswerResponse = TestDnsAnswerResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> recordData = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                testDnsAnswerResponse.recordData(recordData);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Nameserver", targetDepth)) {
                    testDnsAnswerResponse.nameserver(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordName", targetDepth)) {
                    testDnsAnswerResponse.recordName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordType", targetDepth)) {
                    testDnsAnswerResponse.recordType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordData", targetDepth)) {
                    recordData = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("RecordData/RecordDataEntry", targetDepth)) {
                    recordData.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResponseCode", targetDepth)) {
                    testDnsAnswerResponse.responseCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Protocol", targetDepth)) {
                    testDnsAnswerResponse.protocol(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    testDnsAnswerResponse.recordData(recordData);
                    break;
                }
            }
        }
        return testDnsAnswerResponse.build();
    }

    private static final TestDnsAnswerResponseUnmarshaller INSTANCE = new TestDnsAnswerResponseUnmarshaller();

    public static TestDnsAnswerResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
