/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasTarget
implements ToCopyableBuilder<Builder, AliasTarget> {
    private final String hostedZoneId;
    private final String dnsName;
    private final Boolean evaluateTargetHealth;

    private AliasTarget(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.dnsName = builder.dnsName;
        this.evaluateTargetHealth = builder.evaluateTargetHealth;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public Boolean evaluateTargetHealth() {
        return this.evaluateTargetHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluateTargetHealth());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasTarget)) {
            return false;
        }
        AliasTarget other = (AliasTarget)obj;
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.evaluateTargetHealth(), other.evaluateTargetHealth());
    }

    public String toString() {
        return ToString.builder((String)"AliasTarget").add("HostedZoneId", (Object)this.hostedZoneId()).add("DNSName", (Object)this.dnsName()).add("EvaluateTargetHealth", (Object)this.evaluateTargetHealth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "EvaluateTargetHealth": {
                return Optional.ofNullable(clazz.cast(this.evaluateTargetHealth()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String dnsName;
        private Boolean evaluateTargetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasTarget model) {
            this.hostedZoneId(model.hostedZoneId);
            this.dnsName(model.dnsName);
            this.evaluateTargetHealth(model.evaluateTargetHealth);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final Boolean getEvaluateTargetHealth() {
            return this.evaluateTargetHealth;
        }

        @Override
        public final Builder evaluateTargetHealth(Boolean evaluateTargetHealth) {
            this.evaluateTargetHealth = evaluateTargetHealth;
            return this;
        }

        public final void setEvaluateTargetHealth(Boolean evaluateTargetHealth) {
            this.evaluateTargetHealth = evaluateTargetHealth;
        }

        public AliasTarget build() {
            return new AliasTarget(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AliasTarget> {
        public Builder hostedZoneId(String var1);

        public Builder dnsName(String var1);

        public Builder evaluateTargetHealth(Boolean var1);
    }
}

