/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficPolicyInstance
implements ToCopyableBuilder<Builder, TrafficPolicyInstance> {
    private final String id;
    private final String hostedZoneId;
    private final String name;
    private final Long ttl;
    private final String state;
    private final String message;
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;
    private final String trafficPolicyType;

    private TrafficPolicyInstance(BuilderImpl builder) {
        this.id = builder.id;
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.ttl = builder.ttl;
        this.state = builder.state;
        this.message = builder.message;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.trafficPolicyType = builder.trafficPolicyType;
    }

    public String id() {
        return this.id;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String name() {
        return this.name;
    }

    public Long ttl() {
        return this.ttl;
    }

    public String state() {
        return this.state;
    }

    public String message() {
        return this.message;
    }

    public String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    public RRType trafficPolicyType() {
        return RRType.fromValue(this.trafficPolicyType);
    }

    public String trafficPolicyTypeAsString() {
        return this.trafficPolicyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPolicyInstance)) {
            return false;
        }
        TrafficPolicyInstance other = (TrafficPolicyInstance)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyVersion(), other.trafficPolicyVersion()) && Objects.equals(this.trafficPolicyTypeAsString(), other.trafficPolicyTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TrafficPolicyInstance").add("Id", (Object)this.id()).add("HostedZoneId", (Object)this.hostedZoneId()).add("Name", (Object)this.name()).add("TTL", (Object)this.ttl()).add("State", (Object)this.state()).add("Message", (Object)this.message()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("TrafficPolicyVersion", (Object)this.trafficPolicyVersion()).add("TrafficPolicyType", (Object)this.trafficPolicyTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersion()));
            }
            case "TrafficPolicyType": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String hostedZoneId;
        private String name;
        private Long ttl;
        private String state;
        private String message;
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;
        private String trafficPolicyType;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficPolicyInstance model) {
            this.id(model.id);
            this.hostedZoneId(model.hostedZoneId);
            this.name(model.name);
            this.ttl(model.ttl);
            this.state(model.state);
            this.message(model.message);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
            this.trafficPolicyType(model.trafficPolicyType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public final String getTrafficPolicyType() {
            return this.trafficPolicyType;
        }

        @Override
        public final Builder trafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
            return this;
        }

        @Override
        public final Builder trafficPolicyType(RRType trafficPolicyType) {
            this.trafficPolicyType(trafficPolicyType.toString());
            return this;
        }

        public final void setTrafficPolicyType(String trafficPolicyType) {
            this.trafficPolicyType = trafficPolicyType;
        }

        public TrafficPolicyInstance build() {
            return new TrafficPolicyInstance(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TrafficPolicyInstance> {
        public Builder id(String var1);

        public Builder hostedZoneId(String var1);

        public Builder name(String var1);

        public Builder ttl(Long var1);

        public Builder state(String var1);

        public Builder message(String var1);

        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);

        public Builder trafficPolicyType(String var1);

        public Builder trafficPolicyType(RRType var1);
    }
}

