/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTrafficPolicyInstanceRequest
extends Route53Request
implements ToCopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
    private final String id;
    private final Long ttl;
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;

    private UpdateTrafficPolicyInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ttl = builder.ttl;
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
    }

    public String id() {
        return this.id;
    }

    public Long ttl() {
        return this.ttl;
    }

    public String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ttl());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyInstanceRequest)) {
            return false;
        }
        UpdateTrafficPolicyInstanceRequest other = (UpdateTrafficPolicyInstanceRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ttl(), other.ttl()) && Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyVersion(), other.trafficPolicyVersion());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTrafficPolicyInstanceRequest").add("Id", (Object)this.id()).add("TTL", (Object)this.ttl()).add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("TrafficPolicyVersion", (Object)this.trafficPolicyVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "TTL": {
                return Optional.ofNullable(clazz.cast(this.ttl()));
            }
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String id;
        private Long ttl;
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyInstanceRequest model) {
            super(model);
            this.id(model.id);
            this.ttl(model.ttl);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getTTL() {
            return this.ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final void setTTL(Long ttl) {
            this.ttl = ttl;
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrafficPolicyInstanceRequest build() {
            return new UpdateTrafficPolicyInstanceRequest(this);
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    CopyableBuilder<Builder, UpdateTrafficPolicyInstanceRequest> {
        public Builder id(String var1);

        public Builder ttl(Long var1);

        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

