/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.HostedZoneConfig;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.utils.StringInputStream;

public class CreateHostedZoneRequestMarshaller
implements Marshaller<Request<CreateHostedZoneRequest>, CreateHostedZoneRequest> {
    public Request<CreateHostedZoneRequest> marshall(CreateHostedZoneRequest createHostedZoneRequest) {
        if (createHostedZoneRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createHostedZoneRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone";
        request.setResourcePath(uriResourcePath);
        try {
            HostedZoneConfig hostedZoneConfig;
            VPC vpc;
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHostedZoneRequest");
            if (createHostedZoneRequest.name() != null) {
                xmlWriter.startElement("Name").value(createHostedZoneRequest.name()).endElement();
            }
            if ((vpc = createHostedZoneRequest.vpc()) != null) {
                xmlWriter.startElement("VPC");
                if (vpc.vpcRegionAsString() != null) {
                    xmlWriter.startElement("VPCRegion").value(vpc.vpcRegionAsString()).endElement();
                }
                if (vpc.vpcId() != null) {
                    xmlWriter.startElement("VPCId").value(vpc.vpcId()).endElement();
                }
                xmlWriter.endElement();
            }
            if (createHostedZoneRequest.callerReference() != null) {
                xmlWriter.startElement("CallerReference").value(createHostedZoneRequest.callerReference()).endElement();
            }
            if ((hostedZoneConfig = createHostedZoneRequest.hostedZoneConfig()) != null) {
                xmlWriter.startElement("HostedZoneConfig");
                if (hostedZoneConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(hostedZoneConfig.comment()).endElement();
                }
                if (hostedZoneConfig.privateZone() != null) {
                    xmlWriter.startElement("PrivateZone").value((Object)hostedZoneConfig.privateZone()).endElement();
                }
                xmlWriter.endElement();
            }
            if (createHostedZoneRequest.delegationSetId() != null) {
                xmlWriter.startElement("DelegationSetId").value(createHostedZoneRequest.delegationSetId()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

