/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;

public class ListHealthChecksRequestMarshaller
implements Marshaller<Request<ListHealthChecksRequest>, ListHealthChecksRequest> {
    public Request<ListHealthChecksRequest> marshall(ListHealthChecksRequest listHealthChecksRequest) {
        if (listHealthChecksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listHealthChecksRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        if (listHealthChecksRequest.marker() != null) {
            request.addParameter("marker", StringConversion.fromString((String)listHealthChecksRequest.marker()));
        }
        if (listHealthChecksRequest.maxItems() != null) {
            request.addParameter("maxitems", StringConversion.fromString((String)listHealthChecksRequest.maxItems()));
        }
        return request;
    }
}

