/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;

public class TestDnsAnswerRequestMarshaller
implements Marshaller<Request<TestDnsAnswerRequest>, TestDnsAnswerRequest> {
    public Request<TestDnsAnswerRequest> marshall(TestDnsAnswerRequest testDnsAnswerRequest) {
        if (testDnsAnswerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)testDnsAnswerRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/testdnsanswer";
        request.setResourcePath(uriResourcePath);
        if (testDnsAnswerRequest.hostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringConversion.fromString((String)testDnsAnswerRequest.hostedZoneId()));
        }
        if (testDnsAnswerRequest.recordName() != null) {
            request.addParameter("recordname", StringConversion.fromString((String)testDnsAnswerRequest.recordName()));
        }
        if (testDnsAnswerRequest.recordTypeAsString() != null) {
            request.addParameter("recordtype", StringConversion.fromString((String)testDnsAnswerRequest.recordTypeAsString()));
        }
        if (testDnsAnswerRequest.resolverIP() != null) {
            request.addParameter("resolverip", StringConversion.fromString((String)testDnsAnswerRequest.resolverIP()));
        }
        if (testDnsAnswerRequest.edns0ClientSubnetIP() != null) {
            request.addParameter("edns0clientsubnetip", StringConversion.fromString((String)testDnsAnswerRequest.edns0ClientSubnetIP()));
        }
        if (testDnsAnswerRequest.edns0ClientSubnetMask() != null) {
            request.addParameter("edns0clientsubnetmask", StringConversion.fromString((String)testDnsAnswerRequest.edns0ClientSubnetMask()));
        }
        return request;
    }
}

