/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about a geo location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeoLocation implements ToCopyableBuilder<GeoLocation.Builder, GeoLocation> {
    private final String continentCode;

    private final String countryCode;

    private final String subdivisionCode;

    private GeoLocation(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    /**
     * <p>
     * The two-letter code for the continent.
     * </p>
     * <p>
     * Valid values: <code>AF</code> | <code>AN</code> | <code>AS</code> | <code>EU</code> | <code>OC</code> |
     * <code>NA</code> | <code>SA</code>
     * </p>
     * <p>
     * Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
     * <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
     * </p>
     * 
     * @return The two-letter code for the continent.</p>
     *         <p>
     *         Valid values: <code>AF</code> | <code>AN</code> | <code>AS</code> | <code>EU</code> | <code>OC</code> |
     *         <code>NA</code> | <code>SA</code>
     *         </p>
     *         <p>
     *         Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
     *         <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * The two-letter code for the country.
     * </p>
     * 
     * @return The two-letter code for the country.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The code for the subdivision, for example, a state in the United States or a province in Canada.
     * </p>
     * 
     * @return The code for the subdivision, for example, a state in the United States or a province in Canada.
     */
    public String subdivisionCode() {
        return subdivisionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(subdivisionCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation) obj;
        return Objects.equals(continentCode(), other.continentCode()) && Objects.equals(countryCode(), other.countryCode())
                && Objects.equals(subdivisionCode(), other.subdivisionCode());
    }

    @Override
    public String toString() {
        return ToString.builder("GeoLocation").add("ContinentCode", continentCode()).add("CountryCode", countryCode())
                .add("SubdivisionCode", subdivisionCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContinentCode":
            return Optional.ofNullable(clazz.cast(continentCode()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCode()));
        case "SubdivisionCode":
            return Optional.ofNullable(clazz.cast(subdivisionCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, GeoLocation> {
        /**
         * <p>
         * The two-letter code for the continent.
         * </p>
         * <p>
         * Valid values: <code>AF</code> | <code>AN</code> | <code>AS</code> | <code>EU</code> | <code>OC</code> |
         * <code>NA</code> | <code>SA</code>
         * </p>
         * <p>
         * Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
         * <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
         * </p>
         * 
         * @param continentCode
         *        The two-letter code for the continent.</p>
         *        <p>
         *        Valid values: <code>AF</code> | <code>AN</code> | <code>AS</code> | <code>EU</code> | <code>OC</code>
         *        | <code>NA</code> | <code>SA</code>
         *        </p>
         *        <p>
         *        Constraint: Specifying <code>ContinentCode</code> with either <code>CountryCode</code> or
         *        <code>SubdivisionCode</code> returns an <code>InvalidInput</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * The two-letter code for the country.
         * </p>
         * 
         * @param countryCode
         *        The two-letter code for the country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * The code for the subdivision, for example, a state in the United States or a province in Canada.
         * </p>
         * 
         * @param subdivisionCode
         *        The code for the subdivision, for example, a state in the United States or a province in Canada.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionCode(String subdivisionCode);
    }

    static final class BuilderImpl implements Builder {
        private String continentCode;

        private String countryCode;

        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            continentCode(model.continentCode);
            countryCode(model.countryCode);
            subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}
