/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * CreateTrafficPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateTrafficPolicyRequestMarshaller implements
        Marshaller<Request<CreateTrafficPolicyRequest>, CreateTrafficPolicyRequest> {

    public Request<CreateTrafficPolicyRequest> marshall(CreateTrafficPolicyRequest createTrafficPolicyRequest) {

        if (createTrafficPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateTrafficPolicyRequest> request = new DefaultRequest<CreateTrafficPolicyRequest>(createTrafficPolicyRequest,
                "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/trafficpolicy";

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("CreateTrafficPolicyRequest");

            if (createTrafficPolicyRequest.name() != null) {
                xmlWriter.startElement("Name").value(createTrafficPolicyRequest.name()).endElement();
            }

            if (createTrafficPolicyRequest.document() != null) {
                xmlWriter.startElement("Document").value(createTrafficPolicyRequest.document()).endElement();
            }

            if (createTrafficPolicyRequest.comment() != null) {
                xmlWriter.startElement("Comment").value(createTrafficPolicyRequest.comment()).endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}