/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * GetGeoLocationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetGeoLocationRequestMarshaller implements Marshaller<Request<GetGeoLocationRequest>, GetGeoLocationRequest> {

    public Request<GetGeoLocationRequest> marshall(GetGeoLocationRequest getGeoLocationRequest) {

        if (getGeoLocationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<GetGeoLocationRequest> request = new DefaultRequest<GetGeoLocationRequest>(getGeoLocationRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/geolocation";

        request.setResourcePath(uriResourcePath);

        if (getGeoLocationRequest.continentCode() != null) {
            request.addParameter("continentcode", StringConversion.fromString(getGeoLocationRequest.continentCode()));
        }

        if (getGeoLocationRequest.countryCode() != null) {
            request.addParameter("countrycode", StringConversion.fromString(getGeoLocationRequest.countryCode()));
        }

        if (getGeoLocationRequest.subdivisionCode() != null) {
            request.addParameter("subdivisioncode", StringConversion.fromString(getGeoLocationRequest.subdivisionCode()));
        }

        return request;
    }

}