/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ListQueryLoggingConfigsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListQueryLoggingConfigsResponseUnmarshaller implements
        Unmarshaller<ListQueryLoggingConfigsResponse, StaxUnmarshallerContext> {

    public ListQueryLoggingConfigsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListQueryLoggingConfigsResponse.Builder listQueryLoggingConfigsResponse = ListQueryLoggingConfigsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<QueryLoggingConfig> queryLoggingConfigs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listQueryLoggingConfigsResponse.queryLoggingConfigs(queryLoggingConfigs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("QueryLoggingConfigs", targetDepth)) {
                    queryLoggingConfigs = new ArrayList<QueryLoggingConfig>();
                    continue;
                }

                if (context.testExpression("QueryLoggingConfigs/QueryLoggingConfig", targetDepth)) {
                    queryLoggingConfigs.add(QueryLoggingConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listQueryLoggingConfigsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listQueryLoggingConfigsResponse.queryLoggingConfigs(queryLoggingConfigs);
                    break;
                }
            }
        }
        return listQueryLoggingConfigsResponse.build();
    }

    private static final ListQueryLoggingConfigsResponseUnmarshaller INSTANCE = new ListQueryLoggingConfigsResponseUnmarshaller();

    public static ListQueryLoggingConfigsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
