/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * ListTrafficPolicyInstancesByPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListTrafficPolicyInstancesByPolicyRequestMarshaller implements
        Marshaller<Request<ListTrafficPolicyInstancesByPolicyRequest>, ListTrafficPolicyInstancesByPolicyRequest> {

    public Request<ListTrafficPolicyInstancesByPolicyRequest> marshall(
            ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {

        if (listTrafficPolicyInstancesByPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<ListTrafficPolicyInstancesByPolicyRequest> request = new DefaultRequest<ListTrafficPolicyInstancesByPolicyRequest>(
                listTrafficPolicyInstancesByPolicyRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/trafficpolicyinstances/trafficpolicy";

        request.setResourcePath(uriResourcePath);

        if (listTrafficPolicyInstancesByPolicyRequest.trafficPolicyId() != null) {
            request.addParameter("id", StringConversion.fromString(listTrafficPolicyInstancesByPolicyRequest.trafficPolicyId()));
        }

        if (listTrafficPolicyInstancesByPolicyRequest.trafficPolicyVersion() != null) {
            request.addParameter("version",
                    StringConversion.fromInteger(listTrafficPolicyInstancesByPolicyRequest.trafficPolicyVersion()));
        }

        if (listTrafficPolicyInstancesByPolicyRequest.hostedZoneIdMarker() != null) {
            request.addParameter("hostedzoneid",
                    StringConversion.fromString(listTrafficPolicyInstancesByPolicyRequest.hostedZoneIdMarker()));
        }

        if (listTrafficPolicyInstancesByPolicyRequest.trafficPolicyInstanceNameMarker() != null) {
            request.addParameter("trafficpolicyinstancename",
                    StringConversion.fromString(listTrafficPolicyInstancesByPolicyRequest.trafficPolicyInstanceNameMarker()));
        }

        if (listTrafficPolicyInstancesByPolicyRequest.trafficPolicyInstanceTypeMarkerAsString() != null) {
            request.addParameter("trafficpolicyinstancetype", StringConversion
                    .fromString(listTrafficPolicyInstancesByPolicyRequest.trafficPolicyInstanceTypeMarkerAsString()));
        }

        if (listTrafficPolicyInstancesByPolicyRequest.maxItems() != null) {
            request.addParameter("maxitems", StringConversion.fromString(listTrafficPolicyInstancesByPolicyRequest.maxItems()));
        }

        return request;
    }

}